(function () {
    'use strict';

    var jobBuilderController = function ($scope, $http, $uibModal, $rootScope, $location, $timeout, jobBuilderService) {
        $scope.concatenating = false;
        $scope.concat = null;
        $scope.template = {};
        $scope.job = jobBuilderService.getActiveJob();
        $scope.request = {};
        $scope.copyRemotes = false;
        $scope.template_loaded = false;

        $scope.remotes = {};
        $scope.presets = {};
        $scope.templates = {};

        $rootScope.$on('remotes:changed', function () {
            $scope.remotes = jobBuilderService.getRemotes();
        });
        $rootScope.$on('presets:changed', function () {
            $scope.presets = jobBuilderService.getPresets();
        });
        $rootScope.$on('templates:changed', function () {
            $scope.templates = jobBuilderService.getTemplates();
        });
        $rootScope.$on('remote:updated', function () {
            if (requestParameters.filename && requestParameters.location) {
                //after fetching the uploaded files, we check if the current filename we use in the url
                //actually exist. Then we set it as the current file on the first input
                angular.forEach($scope.job.inputs[0].remote.data.files, function (file) {
                    if (file.name === requestParameters.filename) {
                        $scope.job.inputs[0].file = file;
                    }
                });
            }
            $scope.updateApiJob();
        });

        jobBuilderService.init();

        var requestParameters = $location.search();

        $scope.toggleCopyRemotes = function (copyRemotes) {
            $scope.copyRemotes = copyRemotes;
            if ($scope.copyRemotes) {
                var remote = false;
                var foundRemote = false;

                //find the first remote
                angular.forEach($scope.job.inputs, function (input) {
                    angular.forEach(input.outputs, function (output) {
                        if (output.remote && foundRemote === false) {
                            remote = output.remote;
                            foundRemote = true;
                        }
                    });
                });
                //end if no remotes are selected
                if (remote === false) {
                    return;
                }
                //copy remote to all outputs where no remote is set
                angular.forEach($scope.job.inputs, function (input) {
                    angular.forEach(input.outputs, function (output) {
                        output.remote = remote;
                    });
                });

                $scope.updateApiJob();
            }
        };

        $scope.updateRemotesWithCopy = function (remote) {
            if ($scope.copyRemotes) {
                angular.forEach($scope.job.inputs, function (input) {
                    angular.forEach(input.outputs, function (output, outputIndex) {
                        output.remote = remote;
                    });
                });
            }
        };

        if (requestParameters.show_api_request) {
            $scope.show_api_request = true;
        }

        $scope.recommendedWatermarkExtensions = [
            'bmp', 'png', 'jpeg', 'jpg',
            'dpx', 'jls', 'ljpg', 'pam', 'pbm', 'pcx', 'pgm', 'pgmyuv', 'ppm',
            'sgi', 'tga', 'tif', 'tiff', 'jp2', 'j2c', 'j2k', 'xwd', 'sun', 'ras', 'rs', 'im1', 'im8', 'im24',
            'sunras', 'xbm', 'xface', 'pix', 'y'];

        $scope.recommendedCaptionExtensions = ['ass', 'srt'];

        $rootScope.$on('job:updated', function () {
            $scope.job = jobBuilderService.getActiveJob();
            $scope.updateApiJob();
        });

        $scope.sortableOptions = {
            handle: '.move',
            cancel: '',
            stop: function(){
                $scope.updateConcatenateSources();
            }
        };

        $scope.updateConcatenateSources = function () {
            angular.forEach($scope.job.concatenates, function (concatenateItem) {
                var sources = [];
                angular.forEach($scope.job.inputs, function (input) {
                    if (input.outputs.length === 0) {
                        sources.push(input.id);
                    }
                    angular.forEach(input.outputs, function (output, outputIndex) {
                        if (output.seek_offset || output.output_length) {
                            output.temporaryTranscode = true;
                            sources.push(output.id);
                        } else {
                            input.outputs.splice(outputIndex, 1);
                            sources.push(input.id);
                        }
                    });
                });
                concatenateItem.sources = sources;
            });
            $scope.updateApiJob();
        };

        $scope.updateApiJob = function () {
            $scope.request = jobBuilderService.updateApiJob($scope.job);
            $('.prettyprint').html(JSON.stringify($scope.request, null, 4)).removeClass('prettyprinted');
            prettyPrint();

            applyHighlights();
        };

        function applyHighlights() {
            var element = $('.prettyprint');
            var prettyText = element.html();

            var wildcards = ['filename', 'filename_ext', 'unique', 'unique_8', 'unique_16', 'unique_32', 'date', 'time', 'datetime'];

            for (var i = 0; i < wildcards.length; i++) {
                prettyText = prettyText.replace(new RegExp('{{' + wildcards[i] + '}}', 'gi'), '<span class="text-danger">{{' + wildcards[i] + '}}</span>');
            }

            element.html(prettyText);
        }

        $scope.toggleConcat = function (concatenate) {
            if ($scope.concat == concatenate) {
                $scope.concatenating = !$scope.concatenating;
                $scope.concat = null;
            } else {
                $scope.concat = concatenate;
                $scope.concatenating = true;
            }
        };

        $scope.defaultJob = function () {
            $scope.job = {};
            $scope.job.inputs = [];

            var input = {};
            input.id = jobBuilderService.generateUuid();
            input.outputs = [];

            if (requestParameters.filename && requestParameters.location) {
                input.remote = {"id": "upload", "name": "Your uploads", "type": "upload"};
            }

            var output = {};
            output.id = jobBuilderService.generateUuid();
            input.outputs.push(output);

            $scope.job.inputs.push(input);
            $scope.updateApiJob();
        };

        $scope.closeTemplate = function () {
            $scope.template = {};
            $scope.defaultJob();
        };


        $scope.getTemplate = function (templateId) {

            var promise = jobBuilderService.loadTemplate(templateId);
            promise.then(function (data) {

                $scope.job = {};
                var job = data.data;

                $timeout(function () {
                    $scope.job = job;
                    jobBuilderService.setActiveJob(job);
                }, 1);
            });
        };

        //@todo move handling to job builder service
        $scope.submit = function () {
            var isJobValid = true;

            angular.forEach($scope.job.concatenates, function (concatenateItem) {
                concatenateItem.validation_error = false;

                if (concatenateItem.sources.length < 2) {
                    concatenateItem.validation_error = 'Please select multiple in- or outputs (at least 2) ';
                    isJobValid = false;
                }
                if (!concatenateItem.remote) {
                    if (concatenateItem.validation_error !== false) {
                        concatenateItem.validation_error += 'and please select a remote';
                    } else {
                        concatenateItem.validation_error = 'Please select a remote and enter a filename';
                    }
                    isJobValid = false;
                } else if (!concatenateItem.filename) {
                    if (concatenateItem.validation_error !== false) {
                        concatenateItem.validation_error += 'and please enter a filename';
                    } else {
                        concatenateItem.validation_error = 'Please enter a filename';
                    }
                    isJobValid = false;
                }
            });

            angular.forEach($scope.job.inputs, function (inputItem) {
                inputItem.validation_error = false;
                if (!inputItem.remote) {
                    inputItem.validation_error = 'Please select a remote and video file';
                    isJobValid = false;
                } else if (!inputItem.file) {
                    inputItem.validation_error = 'Please select a video file';
                    isJobValid = false;
                }

                angular.forEach(inputItem.outputs, function (outputItem) {
                    outputItem.validation_error = false;

                    if (!outputItem.remote && !outputItem.temporaryTranscode) {
                        outputItem.validation_error = 'Please select a remote';
                        isJobValid = false;
                    }

                    angular.forEach(outputItem.tasks, function (taskItem) {
                        taskItem.validation_error = false;

                        if (taskItem._type === 'watermark' || taskItem._type === 'caption') {
                            if (!taskItem.remote) {
                                taskItem.validation_error = 'Please select a remote and ' + taskItem._type + ' file';
                                isJobValid = false;
                            } else if (!taskItem.file) {
                                taskItem.validation_error = 'Please select a ' + taskItem._type + ' file';
                                isJobValid = false;
                            }
                        } else {
                            if (!taskItem.remote) {
                                taskItem.validation_error = 'Please select a remote';
                                isJobValid = false;
                            }
                        }
                    });
                });
            });

            $scope.job_submitting = true;

            if (isJobValid === false) {
                $scope.job_submitting = false;
                return;
            }

            $scope.updateApiJob();

            $http.post(Routing.generate('isset_bv_hatchery_application_job_builder_submit'), {job: JSON.stringify($scope.request)})
                .success(function (data) {
                    jobBuilderService.setActiveJob({});
                    $rootScope.$broadcast('jobs:update');
                    $scope.defaultJob();
                    $scope.jobAddedFlash = data;
                    $scope.job_submitting = false;
                    $scope.submit_error = false;
                    $scope.submit_warnings = false;
                    $scope.submit_error_tooltip = '';
                }).error(function (data) {
                    if (data.warnings) {
                        $scope.submit_warnings = data.warnings;
                    }
                    if (data.message) {
                        $scope.submit_error = data.message;
                    }else{
                        $scope.submit_error = 'Invalid error response, no message given';
                        $scope.submit_error_tooltip = data;
                    }
                    $scope.job_submitting = false;
                });
        };

        $scope.toggleStrict = function (disableStrict) {
            $scope.job.strict = !disableStrict;
            $scope.updateApiJob();
        };

        //move to template service
        $scope.createTemplate = function ($template) {
            var postData = $http.post(Routing.generate('isset_bv_hatchery_application_job_builder_templates_create'), {
                job: JSON.stringify($scope.job),
                template: $template.name
            });

            postData.then(function () {
                jobBuilderService.initTemplates();
                $scope.modalInstance.dismiss('cancel');
            }, function (result) {
                $scope.template.error = result.data;
            });
        };
        $scope.editTemplate = function ($template) {
            var postData = $http.post(Routing.generate('isset_bv_hatchery_application_job_builder_templates_edit', {id: $template.id}), {
                job: JSON.stringify($scope.job),
                template: $scope.template.name
            });

            postData.then(function () {
                jobBuilderService.initTemplates();
                $scope.modalInstance.dismiss('cancel');
            }, function (result) {
                $scope.template.error = result.data;
            });
        };
        $scope.deleteTemplate = function ($template) {
            var postData = $http.post(Routing.generate('isset_bv_hatchery_application_job_builder_templates_delete', {id: $template.id}), null);

            postData.then(function () {
                jobBuilderService.initTemplates();
                $scope.modalInstance.dismiss('cancel');
                $scope.template = {};
            }, function (result) {
                $scope.template.error = result.data;
            });
        };

        $scope.populateModal = function ($type, $element) {
            var modal = {};
            modal.type = $type;
            modal.element = $element;

            $scope.modal = modal;

            $scope.modalInstance = $uibModal.open({
                templateUrl: '/bundles/issetbvjobbuilder/partials/options.html',
                scope: $scope
            });
        };

        $scope.templateModal = function () {
            $scope.modalInstance = $uibModal.open({
                templateUrl: '/bundles/issetbvjobbuilder/partials/template.html',
                scope: $scope
            });
        };

        $scope.informationModal = function () {
            $scope.modalInstance = $uibModal.open({
                templateUrl: '/bundles/issetbvjobbuilder/partials/information-modal.html',
                scope: $scope
            });
        };

        $scope.cancel = function () {
            $scope.modalInstance.dismiss('cancel');
        };

        $scope.addInput = function () {
            if (!$scope.job) {
                $scope.job = {};
            }

            if (!$scope.job.inputs) {
                $scope.job.inputs = [];
            }

            var $input = {};
            $input.id = jobBuilderService.generateUuid();

            $scope.job.inputs.push($input);
            $scope.updateApiJob();
        };

        $scope.addTranscode = function ($element) {
            if (!$element.outputs) {
                $element.outputs = [];
            }

            var $output = {};
            $output.id =  jobBuilderService.generateUuid();

            if ($element.remote) {
                $output.remote = angular.copy($element.remote);
            }

            $element.outputs.push($output);
            $scope.updateApiJob();
        };

        $scope.addTask = function ($element, $type, $inherit) {

            if (!$element.tasks) {
                $element.tasks = [];
            }

            var object = {};
            object.id = jobBuilderService.generateUuid();
            object._type = $type;

            if ($inherit.remote) {
                object.remote = angular.copy($inherit.remote);
            }
            $element.tasks.push(object);
            $scope.updateApiJob();
        };

        $scope.addConcatTask = function () {

            if (!$scope.job.concatenates) {
                $scope.job.concatenates = [];
            }

            var object = {};
            object.id = jobBuilderService.generateUuid();
            object.type = 'concatenate';
            object.sources = [];

            $scope.job.concatenates.push(object);

            $scope.concatenating = true;
            $scope.concat = object;

            angular.forEach($scope.job.inputs, function (input) {

                angular.forEach(input.outputs, function (output) {
                    $scope.concat.sources.push(output.id);
                });

                if (!input.outputs) {
                    $scope.concat.sources.push(input.id);
                }
            });

            $scope.updateApiJob();
        };
        $scope.addConcatSource = function ($element) {
            var hasSource = false;

            angular.forEach($scope.concat.sources, function (source, key) {
                if (source == $element.id) {
                    $scope.concat.sources.splice(key, 1);
                    hasSource = true;
                }
            });

            if (hasSource === false) {
                $scope.concat.sources.push($element.id);
            }

            $scope.updateApiJob();
        };
        $scope.removeInput = function ($input) {
            $scope.job.inputs.splice($input, 1);
            $scope.updateApiJob();
        };
        $scope.removeConcat = function ($index) {

            if ($scope.concat == $scope.job.concatenates[$index]) {
                $scope.concatenating = false;
            }
            $scope.job.concatenates.splice($index, 1);
            $scope.updateApiJob();
        };
        $scope.removeTranscode = function ($output, $input) {
            $scope.job.inputs[$input].outputs.splice($output, 1);
            $scope.updateApiJob();
        };
        $scope.removeTask = function ($task, $output, $input) {
            $scope.job.inputs[$input].outputs[$output].tasks.splice($task, 1);
            $scope.updateApiJob();
        };

        $scope.buildUrl = function ($element) {
            return jobBuilderService.buildUrl($element);
        };

        $scope.buildBaseUrl = function ($element) {
            return jobBuilderService.buildBaseUrl($element);
        };

        $scope.buildOptions = function (output, $element, options) {
            return jobBuilderService.buildOptions(output, $element, options);
        };

        $scope.buildTransferJob = function () {
            $scope.job_type = 'transfer';

            angular.forEach($scope.job.inputs, function (input) {
                angular.forEach(input.outputs, function (output) {
                    output.remote = {};
                });
            });

            $scope.updateApiJob();
        };

        $scope.buildDownloadJob = function () {
            $scope.job_type = 'download';

            angular.forEach($scope.job.inputs, function (input) {
                angular.forEach(input.outputs, function (output) {

                    output.remote = {id: 'download', name: 'download', type: 'download'};
                });
            });

            $scope.updateApiJob();
        };

        $scope.buildTranscodeJob = function () {
            $scope.job_type = 'transcode';

            angular.forEach($scope.job.inputs, function (input) {
                angular.forEach(input.outputs, function (output) {
                    output.remote = {};
                });
            });

            $scope.updateApiJob();
        };

        $scope.remotes = jobBuilderService.getRemotes();
        $scope.presets = jobBuilderService.getPresets();
        $scope.templates = jobBuilderService.getTemplates();
    };

    angular
        .module('jobBuilder')
        .controller('jobBuilderController', [
            '$scope',
            '$http',
            '$uibModal',
            '$rootScope',
            '$location',
            '$timeout',
            'jobBuilderService',
            jobBuilderController
        ]);
})();
