<?php

namespace IssetBV\JobBuilderBundle\Controller;

use Exception;
use IssetBV\JobBuilderBundle\Entity\JobTemplate;
use IssetBV\JobBuilderBundle\Interfaces\TemplateServiceInterface;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * Class TemplateController
 * @package IssetBV\JobBuilderBundle\Controller
 * @author Bart Malestein <bart@isset.nl>
 */
class TemplateController extends Controller
{

    /**
     * @return JsonResponse
     */
    public function indexAction()
    {
        if (false === $this->container->has($this->container->getParameter('job.builder.template.service.name'))) {

            return new JsonResponse('No service configured for retrieving templates', 404);
        }
        if (false === $this->container->get($this->container->getParameter('job.builder.template.service.name')) instanceof TemplateServiceInterface) {

            return new JsonResponse('Service should implement TemplateServiceInterface', 404);
        }

        /** @var TemplateServiceInterface $templateService */
        $templateService = $this->container->get($this->container->getParameter('job.builder.template.service.name'));

        $data = $templateService->listTemplates();

        return new JsonResponse($data);
    }

    /**
     * @param $id
     * @return JsonResponse
     */
    public function dataAction($id)
    {
        if (false === $this->container->has($this->container->getParameter('job.builder.template.service.name'))) {

            return new JsonResponse('No service configured for retrieving templates', 404);
        }
        if (false === $this->container->get($this->container->getParameter('job.builder.template.service.name')) instanceof TemplateServiceInterface) {

            return new JsonResponse('Service should implement TemplateServiceInterface', 404);
        }

        /** @var TemplateServiceInterface $templateService */
        $templateService = $this->container->get($this->container->getParameter('job.builder.template.service.name'));

        $data = $templateService->showTemplate($id);

        return new JsonResponse($data);

    }

    /**
     * @param Request $request
     * @param JobTemplate $jobTemplate
     * @return JsonResponse
     */
    public function editAction(Request $request, JobTemplate $jobTemplate)
    {
        try {
            $jobTemplate->update($this->getUser()->getCurrentDivision()->uuid, $request->get('template'), $request->get('job'));
            $this->getDoctrine()->getManager()->flush();

            return new JsonResponse();
        } catch (Exception $ex) {
            return new JsonResponse($ex->getMessage(), RESPONSE::HTTP_FORBIDDEN);
        }
    }

    /**
     * @param Request $request
     * @return JsonResponse
     */
    public function createAction(Request $request)
    {
        $jobTemplate = new JobTemplate($this->getUser()->getCurrentDivision()->uuid, $request->get('template'), $request->get('job'));

        $this->getDoctrine()->getManager()->persist($jobTemplate);
        $this->getDoctrine()->getManager()->flush();

        return new JsonResponse();
    }

    /**
     * @param JobTemplate $jobTemplate
     * @return JsonResponse
     */
    public function deleteAction(JobTemplate $jobTemplate)
    {
        try {
            $jobTemplate->delete($this->getUser()->getCurrentDivision()->uuid);
            $this->getDoctrine()->getManager()->flush();

            return new JsonResponse();
        } catch (Exception $ex) {
            return new JsonResponse($ex->getMessage(), RESPONSE::HTTP_FORBIDDEN);
        }
    }
}