'use strict';

var jobBuilderController = angular.module('jobBuilderController', ['ui.bootstrap']);

jobBuilderController.controller('jobBuilderController', ['$scope', '$http', '$modal', '$rootScope',
    function ($scope, $http, $modal, $rootScope) {

        $scope.concatenating = false;
        $scope.concat = null;
        $scope.template = {};

        $scope.toggleConcat = function ($index) {
            $scope.concatenating = !$scope.concatenating;
            $scope.concat = $index;
        };

        $scope.getRemotes = function () {

            $http.get(Routing.generate('isset_bv_hatchery_application_job_builder_remotes')).success(function (data) {
                $scope.remotes = data;
            });
        };
        $scope.getPresets = function () {
            $http.get(Routing.generate('isset_bv_hatchery_application_job_builder_presets', {actionType: 'video-transcode'})).success(function (data) {
                $scope.presets = data;
            });
        };
        $scope.getTemplates = function () {
            $http.get(Routing.generate('isset_bv_hatchery_application_job_builder_templates')).success(function (data) {
                $scope.templates = data;
            });
        };

        $scope.defaultJob = function () {
            $rootScope.job = {};
            $rootScope.job.inputs = [];
            var input = {};
            input.id = generateUuid();
            input.outputs = [];
            var output = {};
            output.id = generateUuid();
            input.outputs.push(output);
            $rootScope.job.inputs.push(input);
            $scope.updateApiJob();
        };

        $scope.getTemplate = function () {
            $http.get(Routing.generate('isset_bv_hatchery_application_job_builder_templates_data', {id: $scope.template.id})).success(function (data) {
                $rootScope.job = data;
                $scope.updateApiJob();
            });
        };
        $scope.getTemplates();
        $scope.getRemotes();
        $scope.getPresets();

        $scope.submit = function () {
            $http.post(Routing.generate('isset_bv_hatchery_application_job_builder_submit'), {job: JSON.stringify($scope.request)})
                .success(function (data) {
                    window.location = data;
                }).error(function (data) {
                    $scope.submit_error = data;
                });
        };

        $scope.createTemplate = function ($template) {
            var postData = $http.post(Routing.generate('isset_bv_hatchery_application_job_builder_templates_create'), {
                job: JSON.stringify($rootScope.job),
                template: $template.name
            });

            postData.then(function (result) {
                $scope.getTemplates();
                $scope.modalInstance.dismiss('cancel');
            }, function (result) {
                $scope.template.error = result.data;
            });
        };
        $scope.editTemplate = function ($template) {
            var postData = $http.post(Routing.generate('isset_bv_hatchery_application_job_builder_templates_edit', {id: $template.id}), {
                job: JSON.stringify($rootScope.job),
                template: $scope.template.name
            });

            postData.then(function (result) {
                $scope.getTemplates();
                $scope.modalInstance.dismiss('cancel');
            }, function (result) {
                $scope.template.error = result.data;
            });
        };
        $scope.deleteTemplate = function ($template) {
            var postData = $http.post(Routing.generate('isset_bv_hatchery_application_job_builder_templates_delete', {id: $template.id}));

            postData.then(function (result) {
                $scope.getTemplates();
                $scope.modalInstance.dismiss('cancel');
                $scope.template = {};
            }, function (result) {
                $scope.template.error = result.data;
            });
        };


        $scope.browseRemote = function ($element, $index, $directory) {
            if ($index.type === 'archive') {
                $scope.browse('isset_bv_hatchery_application_job_builder_browse_archive', $element, $index, $directory);
            } else if ($index.type === 'upload') {
                $scope.browse('isset_bv_hatchery_application_job_builder_browse_uploads', $element, $index, $directory);
            } else {
                $scope.browse('isset_bv_hatchery_application_job_builder_browse_remote', $element, $index, $directory);
            }
        };

        $scope.browse = function ($endPoint, $element, $index, $directory) {
            $element.error = false;
            $element.loading = true;
            $element.selected_remote = $index;

            $http.get(Routing.generate($endPoint, {
                remoteIdentifier: $element.selected_remote.id,
                directory: $directory
            })).success(function (data) {
                $element.loading = false;
                $element.remote = data;
                $scope.updateApiJob();
            }).error(function (data) {
                $element.loading = false;
                $element.error = true;
                $element.remote = null;
            });
        };

        $scope.selectDownload = function ($element) {
            $element.selected_remote = {id: 'download', name: 'download', type: 'download'};
            $element.remote = {files: []};
            $scope.updateApiJob();
        };


        $scope.populateModal = function ($type, $element) {
            var modal = {};
            modal.type = $type;
            modal.element = $element;

            $scope.modal = modal;

            $scope.modalInstance = $modal.open({
                templateUrl: '/bundles/issetbvjobbuilder/partials/options.html',
                scope: $scope
            });
        };

        $scope.templateModal = function () {
            $scope.modalInstance = $modal.open({
                templateUrl: '/bundles/issetbvjobbuilder/partials/template.html',
                scope: $scope
            });
        };

        $scope.cancel = function () {
            $scope.modalInstance.dismiss('cancel');
        };

        $scope.addInput = function () {
            if (!$rootScope.job) {
                $rootScope.job = {}
            }

            if (!$rootScope.job.inputs) {
                $rootScope.job.inputs = [];
            }

            var $input = {};
            $input.id = generateUuid();

            $rootScope.job.inputs.push($input);
            $scope.updateApiJob();
        };

        $scope.addTranscode = function ($element) {
            if (!$element.outputs) {
                $element.outputs = [];
            }

            var $output = {};
            $output.id = generateUuid();

            if ($element.selected_remote) {
                $output.selected_remote = angular.copy($element.selected_remote);
                $output.remote = angular.copy($element.remote);
            }

            $element.outputs.push($output);
            $scope.updateApiJob();
        };

        $scope.addTask = function ($element, $type, $inherit) {

            if (!$element.tasks) {
                $element.tasks = [];
            }

            var object = {};
            object.id = generateUuid();
            object._type = $type;

            if ($inherit.selected_remote) {
                object.selected_remote = angular.copy($inherit.selected_remote);
                object.remote = angular.copy($inherit.remote);
            }
            $element.tasks.push(object);
            $scope.updateApiJob();
        };

        $scope.addConcatTask = function () {

            if (!$rootScope.job.concatenates) {
                $rootScope.job.concatenates = [];
            }

            var object = {};
            object.id = generateUuid();
            object.type = 'concatenate';
            object.sources = [];

            $rootScope.job.concatenates.push(object);
            $scope.updateApiJob();
        };
        $scope.addConcatSource = function ($element) {
            $scope.concat.sources.push($element.id);
            $scope.updateApiJob();
        };
        $scope.removeInput = function ($input) {
            $rootScope.job.inputs.splice($input, 1);
            $scope.updateApiJob();
        };
        $scope.removeConcat = function ($concat) {
            $rootScope.job.concatenates.splice($concat, 1);
            $scope.updateApiJob();
            $scope.concatenating = false;
        };
        $scope.removeTranscode = function ($output, $input) {
            $rootScope.job.inputs[$input].outputs.splice($output, 1);
            $scope.updateApiJob();
        };
        $scope.removeTask = function ($task, $output, $input) {
            $rootScope.job.inputs[$input].outputs[$output].tasks.splice($task, 1);
            $scope.updateApiJob();
        };

        $rootScope.updateApiJob = function () {

            var request = {};

            request.inputs = [];
            request.outputs = [];

            var playlist = {};
            playlist.type = 'playlist';
            playlist.reference = generateUuid();
            playlist.filename = 'playlist.m3u8';
            playlist.streams = [];

            angular.forEach($rootScope.job.inputs, function ($element) {
                var input = {};
                input.reference = $element.id;
                input.url = $scope.buildUrl($element, true);
                request.inputs.push(input);

                angular.forEach($element.outputs, function ($element) {
                    var output = {};
                    output.reference = $element.id;
                    output.source = input.reference;
                    output.filename = $element.filename;

                    if ($element.selected_remote && $element.selected_remote.type === 'download') {
                        output.download = true;
                    } else {
                        output.base_url = $scope.buildBaseUrl($element);
                    }

                    request.outputs.push(output);
                    $scope.buildOptions(output, $element, ['preset', 'seek_offset', 'output_length', 'width', 'height', 'deinterlace', 'type']);


                    if ($element.type === 'segmented') {
                        playlist.base_url = output.base_url;
                        playlist.streams.push(output.reference);
                    }

                    angular.forEach($element.tasks, function ($element) {

                        if ($element === 'caption') {
                            output.caption_url = $scope.buildUrl($element);
                        } else if ($element._type === 'transfer') {
                            var transfer = {};
                            transfer.type = "transfer-only";
                            transfer.source = output.reference;
                            transfer.base_url = $scope.buildBaseUrl($element);
                            transfer.filename = $element.filename;
                            request.outputs.push(transfer);
                        } else if ($element._type === 'watermark') {
                            if (!output.watermarks) {
                                output.watermarks = [];
                            }

                            var watermark = {};
                            watermark.url = $scope.buildUrl($element);
                            $scope.buildOptions(watermark, $element, ['width', 'height', 'x', 'y']);

                            output.watermarks.push(watermark);
                        } else if ($element._type === 'stills') {
                            if (!output.stills) {
                                output.stills = [];
                            }

                            var stills = {};
                            stills.base_url = $scope.buildBaseUrl($element);
                            stills.filename = $element.filename;
                            $scope.buildOptions(stills, $element, ['width', 'height', 'amount', 'format', 'timestamp']);

                            output.stills.push(stills);
                        }
                    });
                });
            });

            angular.forEach($rootScope.job.concatenates, function ($element) {
                var output = {};
                output.type = 'concatenate';
                output.source = $element.sources;
                output.base_url = $scope.buildBaseUrl($element);
                output.filename = $element.filename;
                request.outputs.push(output);
            });

            if (playlist.streams.length > 0) {
                request.outputs.push(playlist);
            }

            $scope.request = request;
            $('.prettyprint').html(JSON.stringify($scope.request, null, 4)).removeClass('prettyprinted');
            prettyPrint();
        };

        $scope.buildUrl = function ($element) {
            if ($element.remote && $element.selected_remote.id === 'upload') {
                if ($element.file && $element.file.location) {

                    return $element.file.location;
                }else if($element.file && !$element.file.location){

                    return '';
                }
            }

            if ($element.remote && $element.selected_remote.id === 'archive') {
                if ($element.file) {
                    return 'va://my.videoarchive.io/' + $element.file.location;
                } else if ($element.remote.directory) {
                    return 'va://my.videoarchive.io/' + $element.remote.directory;
                } else {
                    return 'va://my.videoarchive.io/'
                }
            }

            if ($element.remote && $element.remote.directory && $element.file) {
                return 'remote://' + $element.selected_remote.id + '/' + $element.remote.directory + $element.file.location;
            } else if ($element.remote && $element.file) {
                return 'remote://' + $element.selected_remote.id + '/' + $element.file.location;
            } else if ($element.remote) {
                return 'remote://' + $element.selected_remote.id + '/';
            } else {
                return '';
            }
        };

        $scope.buildBaseUrl = function ($element) {

            if ($element.remote && $element.selected_remote.id === 'archive') {
                if ($element.remote.directory) {
                    return 'va://my.videoarchive.io/' + $element.remote.directory;
                } else {
                    return 'va://my.videoarchive.io/'
                }
            }

            if ($element.remote && $element.remote.directory) {
                return 'remote://' + $element.selected_remote.id + '/' + $element.remote.directory;
            } else if ($element.remote) {
                return 'remote://' + $element.selected_remote.id + '/';
            } else {
                return '';
            }
        };

        $scope.buildOptions = function (output, $element, options) {
            angular.forEach(options, function (option) {
                if ($element.hasOwnProperty(option) && $element[option]) {
                    output[option] = $element[option];
                }
            });
        };

        $scope.buildTransferJob = function(){
            $scope.job_type = 'transfer';

            angular.forEach($rootScope.job.inputs, function (input) {
                angular.forEach(input.outputs, function (output) {
                    output.selected_remote = null;
                    output.remote = null;
                });
            });

            $rootScope.updateApiJob();
        };

        $scope.buildDownloadJob = function () {
            $scope.job_type = 'download';

            angular.forEach($rootScope.job.inputs, function (input) {
                angular.forEach(input.outputs, function (output) {

                    output.selected_remote = {id: 'download', name: 'download', type: 'download'};
                    output.remote = {files: []};
                });
            });

            $rootScope.updateApiJob();
        };

        $scope.buildTranscodeJob = function(){
            $scope.job_type = 'transcode';

            angular.forEach($rootScope.job.inputs, function (input) {
                angular.forEach(input.outputs, function (output) {
                    output.selected_remote = null;
                    output.remote = null;
                });
            });

            $rootScope.updateApiJob();
        };

    }
]).filter('getIcon', function () {
    return function (type) {
        switch (type.toLowerCase()) {
            case 'ftp':
                return 'fa-share-alt';
            case 'dropbox':
                return 'fa-dropbox';
            case 'googledrive':
                return 'fa-google';
            case 'archive':
                return 'fa-cloud';
            case 'amazon':
                return 'fa-cube';
            case 'youtube':
                return 'fa-youtube';
            case 'input':
                return 'fa-file-video-o';
            case 'transcode':
                return 'fa-tasks';
            case 'segmented':
                return 'fa-tasks';
            case 'transfer':
                return 'fa-share-alt';
            case 'stills':
                return 'fa-picture-o';
            case 'watermark':
                return 'fa-copyright';
            case 'caption':
                return 'fa-comments-o';
            case 'concatenate':
                return 'fa-paperclip';
            case 'upload':
                return 'fa-upload';
        }

    }
}).filter('positionInArray', function () {
    return function (array, value) {
        return array.indexOf(value) !== -1 ? array.indexOf(value) + 1 : null;
    };
});

function generateUuid() {
    function s4() {
        return Math.floor((1 + Math.random()) * 0x10000)
            .toString(16)
            .substring(1);
    }

    return s4() + s4() + '-' + s4() + '-' + s4() + '-' +
        s4() + '-' + s4() + s4() + s4();
}

function secondsToTimestamp(secondsRaw) {
    var sec_num = parseInt(secondsRaw, 10);

    var hours = Math.floor(sec_num / 3600);
    var minutes = Math.floor((sec_num - (hours * 3600)) / 60);
    var seconds = sec_num - (hours * 3600) - (minutes * 60);

    if (hours < 10) {
        hours = "0" + hours;
    }
    if (minutes < 10) {
        minutes = "0" + minutes;
    }
    if (seconds < 10) {
        seconds = "0" + seconds;
    }

    return hours + ':' + minutes + ':' + seconds;
}