(function () {
    'use strict';

    var folderValidation = function () {
        return {
            require: 'ngModel',
            link: function (scope, elm, attrs, ctrl) {
                if (!ctrl) return;
                var regex = /^[^\\/?%*:|"<>]+$/;

                var validator = function (value) {
                    if (ctrl.$isEmpty(value)) {
                        ctrl.$setValidity('folderValidation', true);
                    } else if (value == '..' || value == '.') {
                        ctrl.$setValidity('folderValidation', false);
                    } else {
                        ctrl.$setValidity('folderValidation', regex.test(value));
                    }
                    return value;
                };
                ctrl.$parsers.unshift(validator);
            }
        };
    };

    angular
        .module('jobBuilder')
        .directive('folderValidation', [
            folderValidation
        ]);
})();