<?php

namespace IssetBV\JobBuilderBundle\Controller;

use IssetBV\JobBuilderBundle\Interfaces\JobServiceInterface;
use IssetBV\JobBuilderBundle\Interfaces\StrictWarningExceptionInterface;
use ReflectionClass;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * Class JobBuilderController.
 *
 * @author Bart Malestein <bart@isset.nl>
 */
class JobBuilderController extends Controller
{
    /**
     * @return Response
     */
    public function createAction()
    {
        return $this->render('IssetBVJobBuilderBundle:JobBuilder:job.html.twig');
    }

    /**
     * @param Request $request
     *
     * @return Response
     */
    public function submitAction(Request $request)
    {
        $jsonData = $request->get('job');

        if (false === $this->container->has($this->container->getParameter('job.builder.job.service.name'))) {
            return new JsonResponse('No service configured for sending jobs', 404);
        }
        if (false === $this->container->get($this->container->getParameter('job.builder.job.service.name')) instanceof JobServiceInterface) {
            return new JsonResponse('Service should implement JobServiceInterface', 404);
        }

        try {
            $redirectUrl = $this->container->get($this->container->getParameter('job.builder.job.service.name'))->submit($jsonData);

            return new Response($redirectUrl, 202);
        } catch (StrictWarningExceptionInterface $ex) {
            $data = [];
            $data['message'] = $ex->getMessage();
            $data['warnings'] = $ex->getWarnings();

            return new JsonResponse($data, 400);
        } catch (\Exception $e) {
            $data = [];
            $reflect = new ReflectionClass($e);
            $data['message'] = $reflect->getShortName() . ': ' . $e->getMessage();

            return new JsonResponse($data, 400);
        }
    }
}
