<?php

namespace IssetBV\JobBuilderBundle\Service\Presenter;

use Symfony\Component\HttpFoundation\Session\Session;

/**
 * Class ArchiveResponsePresenter.
 *
 * @author Bart Malestein <bart@isset.nl>
 */
class ArchiveResponsePresenter
{
    /**
     * @var Session
     */
    private $session;

    /**
     * @param Session $session
     */
    public function __construct(Session $session)
    {
        $this->session = $session;
    }

    /**
     * @param array $files
     * @param $directory
     *
     * @return array
     */
    public function presentFiles(array $files, $directory)
    {
        $filesFormatted = [];
        $folders = [];
        foreach ($files as $file) {
            if ($file['isFolder']) {
                $file['location'] = $file['uuid'];
                $folders[] = $file;
            } else {
                $file['location'] = $file['name'] . '?uuid=' . $file['uuid'];
                $filesFormatted[] = $file;
            }
        }

        $data = [
            'files' => $filesFormatted,
            'folders' => $folders,
            'directory' => $directory,
            'breadcrumb' => $this->session->get('breadcrumb'),
        ];

        return $data;
    }
}
