(function () {
    'use strict';

    var jobRemotesFolders = function () {
        var directive = {
            restrict: 'EA',
            templateUrl: '/bundles/issetbvjobbuilder/partials/job-remotes-folders.html',
            scope: {
                remote: '='
            },
            link: linkFunc,
            controller: 'jobRemotesController',
            controllerAs: 'jobRemotes',
            bindToController: true
        };

        return directive;

        function linkFunc(scope, el, attr, ctrl) {
            scope.$watch('jobRemotes.remote', function (e) {
                if(ctrl.remote.type !== 'download'){

                    if(ctrl.remote.data && ctrl.remote.data.directory){
                        ctrl.browseRemote(ctrl.remote, ctrl.remote.data.directory);
                    }else{
                        ctrl.browseRemote(ctrl.remote, '');
                    }
                }
            });
        }
    };

    angular
        .module('jobRemotes')
        .directive('jobRemotesFolders', [
            jobRemotesFolders
        ]);
})();