<?php

namespace IssetBV\JobBuilderBundle\Controller;

use Exception;
use IssetBV\JobBuilderBundle\Entity\JobTemplate;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * Class TemplateController
 * @package IssetBV\JobBuilderBundle\Controller
 * @author Bart Malestein <bart@isset.nl>
 */
class TemplateController extends Controller
{

    /**
     * @return JsonResponse
     */
    public function indexAction()
    {
        $divisionUuid = $this->getUser()->getCurrentDivision()->uuid;

        $templates = $this->getDoctrine()->getRepository('IssetBVJobBuilderBundle:JobTemplate')->findAvailableForDivision($divisionUuid);

        $arr = [];
        foreach ($templates as $template) {
            $arr[] = [
                'id' => $template->getId(),
                'name' => $template->getName()
            ];
        }

        return new JsonResponse($arr);
    }

    /**
     * @param JobTemplate $jobTemplate
     * @return JsonResponse
     */
    public function dataAction(JobTemplate $jobTemplate)
    {
        return new Response($jobTemplate->getData());
    }

    /**
     * @param Request $request
     * @param JobTemplate $jobTemplate
     * @return JsonResponse
     */
    public function editAction(Request $request, JobTemplate $jobTemplate)
    {
        try {
            $jobTemplate->update($this->getUser()->getCurrentDivision()->uuid, $request->get('template'), $request->get('job'));
            $this->getDoctrine()->getManager()->flush();

            return new JsonResponse();
        } catch (Exception $ex) {
            return new JsonResponse($ex->getMessage(), RESPONSE::HTTP_FORBIDDEN);
        }
    }

    /**
     * @param Request $request
     * @return JsonResponse
     */
    public function createAction(Request $request)
    {
        $jobTemplate = new JobTemplate($this->getUser()->getCurrentDivision()->uuid, $request->get('template'), $request->get('job'));

        $this->getDoctrine()->getManager()->persist($jobTemplate);
        $this->getDoctrine()->getManager()->flush();

        return new JsonResponse();
    }

    /**
     * @param JobTemplate $jobTemplate
     * @return JsonResponse
     */
    public function deleteAction(JobTemplate $jobTemplate)
    {
        try {
            $jobTemplate->delete($this->getUser()->getCurrentDivision()->uuid);
            $this->getDoctrine()->getManager()->flush();

            return new JsonResponse();
        } catch (Exception $ex) {
            return new JsonResponse($ex->getMessage(), RESPONSE::HTTP_FORBIDDEN);
        }
    }
}