(function () {
    'use strict';

    var recommendedExtensions = function () {
        return {
            require: 'ngModel',
            scope: {
                recommendedExtensions: '='
            },
            link: function (scope, elem, attr, ctrl) {

                //on recommended extension change, update field validation
                scope.$watch('recommendedExtensions', function (recommendedExtensions) {
                    if (elem.val().length > 0) {
                        scope.recommendedExtensions = recommendedExtensions;
                        scope.validator(elem.val());
                    }
                });

                scope.validator = function (value) {
                    var isValid = false;

                    //no recommendedExtensions, so no validation
                    if (!scope.recommendedExtensions) {
                        isValid = true;
                    }

                    var validateValue;
                    //select returns object, use name
                    if (angular.isObject(value)) {
                        validateValue = value.name;
                    } else {
                        validateValue = value;
                    }

                    //No dot, so no extension. No validation necessary
                    if (validateValue.lastIndexOf('.') === -1) {
                        isValid = true;
                    }

                    //Strip extension from current value
                    var currentExtension = validateValue.substr(validateValue.lastIndexOf('.') + 1);

                    angular.forEach(scope.recommendedExtensions, function (recommendedExtension, index) {
                        if (currentExtension == recommendedExtension) {
                            isValid = true;
                        }
                    });

                    ctrl.$setValidity('recommendedExtensions', isValid);

                    return value;
                };
                ctrl.$parsers.unshift(scope.validator);
            }
        };
    };

    angular
        .module('jobBuilder')
        .directive('recommendedExtensions', [
            recommendedExtensions
        ]);
})();