(function () {
    'use strict';

    var getIcon = function (a) {

        return function (type) {

            if (type) {

                switch (type.toLowerCase()) {
                    case 'ftp':
                        return 'fa-share-alt';
                    case 'dropbox':
                        return 'fa-dropbox';
                    case 'googledrive':
                        return 'fa-google';
                    case 'archive':
                        return 'fa-cloud';
                    case 'amazon':
                        return 'fa-cube';
                    case 'youtube':
                        return 'fa-youtube';
                    case 'input':
                        return 'fa-file-video-o';
                    case 'transcode':
                        return 'fa-tasks';
                    case 'segmented':
                        return 'fa-tasks';
                    case 'transfer':
                        return 'fa-share-alt';
                    case 'stills':
                        return 'fa-picture-o';
                    case 'watermark':
                        return 'fa-copyright';
                    case 'caption':
                        return 'fa-comments-o';
                    case 'concatenate':
                        return 'fa-paperclip';
                    case 'upload':
                        return 'fa-upload';
                    case 'download':
                        return 'fa-download';
                }

            }
        };

    };

    angular
        .module('jobBuilder')
        .filter('getIcon', [
            '$rootScope',
            getIcon
        ]);

})();