(function() {
    'use strict';

    var jobRemotesController = function($rootScope, $http) {
        var vm = this;

        vm.setRemote = setRemote;
        vm.browseRemote = browseRemote;
        vm.browse = browse;
        vm.addDirectory = addDirectory;
        vm.selectDownload = selectDownload;

        function selectDownload() {
            vm.remote = {id: 'download', name: 'download', type: 'download'};
        }

        function setRemote(remote) {
            vm.remote = angular.copy(remote);
        }

        function browseRemote(remote, path) {
            if(remote) {
                if (remote.type === 'archive') {
                    vm.browse('isset_bv_hatchery_application_job_builder_browse_archive', remote, path);
                } else if (remote.type === 'upload') {
                    vm.browse('isset_bv_hatchery_application_job_builder_browse_uploads', remote, path);
                } else {
                    vm.browse('isset_bv_hatchery_application_job_builder_browse_remote', remote, path);
                }
            }
        }

        function browse(endPoint, remote, path) {
            remote.error = false;
            remote.loading = true;

            $http.get(Routing.generate(endPoint, {
                remoteIdentifier: remote.id,
                directory: path
            })).then(function (result) {
                remote.loading = false;
                remote.data = result.data;
                $rootScope.$broadcast('remote:updated');
            }, function () {
                remote.loading = false;
                remote.error = true;
                remote.remote = null;
            });
        }

        function addDirectory(remote, folder) {

            if (!folder)  return;

            remote.loading = true;

            var newDirectory;
            if (remote.data.directory === "") {
                newDirectory = folder;
            } else {
                newDirectory = remote.data.directory + folder;
            }

            if (remote.type === 'archive') {
                if (remote.data.directory.length > 0) {
                    var postData = $http.post(Routing.generate('isset_bv_hatchery_application_job_builder_add_archive_directory'), {
                        folder: folder,
                        parent: remote.data.directory
                    });

                    postData.then(function (result) {
                        newDirectory = result.data.uuid;
                        vm.browseRemote(remote, newDirectory);
                    }, function () {
                        remote.loading = false;
                        remote.error = true;
                    });
                }
            } else {
                vm.browseRemote(remote, newDirectory);
            }
        }

    };

    angular
        .module('jobRemotes')
        .controller('jobRemotesController', [
            '$rootScope',
            '$http',
            jobRemotesController
        ]);
})();