(function() {
    'use strict';

    var jobRemotesController = function($http) {
        var vm = this;

        vm.remote = false;

        vm.setRemote = setRemote;
        vm.browseRemote = browseRemote;
        vm.browse = browse;

        function setRemote(remote) {
            vm.remote = remote;
        }

        function browseRemote(remote, path) {
            if(remote) {
                if (remote.type === 'archive') {
                    vm.browse('isset_bv_hatchery_application_job_builder_browse_archive', remote, path);
                } else if (remote.type === 'upload') {
                    vm.browse('isset_bv_hatchery_application_job_builder_browse_uploads', remote, path);
                } else {
                    vm.browse('isset_bv_hatchery_application_job_builder_browse_remote', remote, path);
                }
            }
        }

        function browse(endPoint, remote, path) {
            remote.error = false;
            remote.loading = true;

            $http.get(Routing.generate(endPoint, {
                remoteIdentifier: remote.id,
                directory: path
            })).then(function (result) {
                remote.loading = false;
                remote.data = result.data;
            }, function (result) {
                remote.loading = false;
                remote.error = true;
                remote.remote = null;
            });
        }

    };

    angular
        .module('jobRemotes')
        .controller('jobRemotesController', [
            '$http',
            jobRemotesController
        ]);
})();