<?php

namespace IssetBV\JobBuilderBundle\Repository;

use Doctrine\ORM\EntityRepository;
use IssetBV\JobBuilderBundle\Entity\JobTemplate;


/**
 * Class JobTemplateRepository
 * @author Bart Malestein <bart@isset.nl>
 */
class JobTemplateRepository extends EntityRepository{

    /**
     * @param $divisionUuid
     * @return JobTemplate[]
     */
    public function findAvailableForDivision($divisionUuid){

        $qb = $this->createQueryBuilder('t');

        $qb->where($qb->expr()->orX(
            $qb->expr()->eq('t.division', ':divisionUuid'),
            $qb->expr()->isNull('t.division')
        ));

        $qb->andWhere('t.dateDeleted IS NULL');

        $qb->setParameter('divisionUuid', $divisionUuid);

        return $qb->getQuery()->getResult();
    }

}