<?php

namespace IssetBV\JobBuilderBundle\Service\Presenter;

use Exception;

/**
 * Class FilesResponsePresenter
 * @package IssetBV\JobBuilderBundle\Service\Presenter
 * @author Bart Malestein <bart@isset.nl>
 */
class FilesResponsePresenter
{

    /**
     * @param array $data
     * @param $directory
     * @return array
     * @throws \Exception
     */
    public function presentFiles(array $data, $directory)
    {

        if (!isset($data['files'])) {
            throw new Exception('Invalid array, expecting data[files]');
        }

        if($directory === ''){
            $directory = trim($data['remote']['path'], "/") . "/";
        }


        $files = [];
        $folders = [];
        foreach ($data['files'] as $file) {
            $file['location'] = $directory . $file['name'];

            if ($file['isFolder']) {
                $folders[] = $file;
            } else {
                $files[] = $file;
            }

        }


        $data = [
            'files' => $files,
            'folders' => $folders,
            'directory' => $directory,
            'breadcrumb' => $this->getBreadCrumb($directory)
        ];

        return $data;
    }


    /**
     * @param $directory
     * @return string
     */
    private function getBreadCrumb($directory)
    {
        $breadCrumb = [];
        $directory = trim($directory, "/");

        if (empty($directory)) {
            return $breadCrumb;
        }

        //remove trailing slash
        $trimmedDirectory = rtrim($directory, "/");
        //split up directory elements
        $directoryParts = explode("/", $trimmedDirectory);

        while (count($directoryParts) > 0) {
            $breadCrumb[] =
                [
                    'name' => $directoryParts[count($directoryParts) - 1],
                    'location' => implode("/", $directoryParts) . "/"
                ];

            array_pop($directoryParts);
        }
        return array_reverse($breadCrumb);
    }

}