<?php

namespace IssetBV\JobBuilderBundle\Controller;

use IssetBV\JobBuilderBundle\Interfaces\JobServiceInterface;
use ReflectionClass;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * Class JobBuilderController
 * @package IssetBV\JobBuilderBundle\Controller
 * @author Bart Malestein <bart@isset.nl>
 */
class JobBuilderController extends Controller
{

    /**
     * @return Response
     */
    public function createAction()
    {
        return $this->render('IssetBVJobBuilderBundle:JobBuilder:job.html.twig');
    }

    /**
     * @param Request $request
     * @return Response
     */
    public function submitAction(Request $request)
    {
        $jsonData = $request->get('job');

        if (false === $this->container->has($this->container->getParameter('job.builder.job.service.name'))) {

            return new JsonResponse('No service configured for sending jobs', 404);
        }
        if (false === $this->container->get($this->container->getParameter('job.builder.job.service.name')) instanceof JobServiceInterface) {

            return new JsonResponse('Service should implement JobServiceInterface', 404);
        }

        try {
            $redirectUrl = $this->container->get($this->container->getParameter('job.builder.job.service.name'))->submit($jsonData);

            return new Response($redirectUrl, 202);

        } catch (\Exception $e) {
            $reflect = new ReflectionClass($e);
            return new Response($reflect->getShortName() . ': ' . $e->getMessage(), 400);
        }
    }
}

