<?php

namespace IssetBV\JobBuilderBundle\Controller;

use IssetBV\JobBuilderBundle\Interfaces\JobServiceInterface;
use ReflectionClass;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * Class JobBuilderController
 * @package IssetBV\JobBuilderBundle\Controller
 * @author Bart Malestein <bart@isset.nl>
 */
class JobBuilderController extends Controller
{

    /**
     * @return Response
     */
    public function createAction()
    {
        return $this->render('IssetBVJobBuilderBundle:JobBuilder:job.html.twig');
    }

    /**
     * @param Request $request
     * @return Response
     */
    public function submitAction(Request $request)
    {

        /** @var \IssetBV\AccountBundle\Entity\Account $creator */
        $creator = $this->getUser()->getEntity();

        $jsonData = $request->get('job');

        //replace paths for uploaded files, users can download via the url they see in the job builder,
        //but this gets replaced for an internal ftp url here for performance increase and cost decrease.
        $uploadPath = $this->container->getParameter('job.builder.upload.folder.http'); //http://upload.videotranscoder.io/data/file.mp4
        $ftpPath = $this->container->getParameter('job.builder.upload.folder.ftp'); //ftp://transfer:rCah7dDiMpPgH9UF@isset103.internal.isset.net/volume0/upload/file.mp4
        //simple string replace
        $jsonData = str_replace($uploadPath, $ftpPath, $jsonData);

        //replace placeholder "download": true' (which also works), with the actual email address of the creator
        $downloadIdentifier = '"download": true';
        $downloadReplace = sprintf('"download": ["%s"]', $creator->getEmail());
        $jsonData = str_replace($downloadIdentifier, $downloadReplace, $jsonData);



        if (false === $this->container->has($this->container->getParameter('job.builder.job.service.name'))) {

            return new JsonResponse('No service configured for sending jobs', 404);
        }
        if (false === $this->container->get($this->container->getParameter('job.builder.job.service.name')) instanceof JobServiceInterface) {

            return new JsonResponse('Service should implement JobServiceInterface', 404);
        }

        try {
            $redirectUrl = $this->container->get($this->container->getParameter('job.builder.job.service.name'))->submit($jsonData);

            return new Response($redirectUrl, 202);

        } catch (\Exception $e) {
            $reflect = new ReflectionClass($e);
            return new Response($reflect->getShortName() . ': ' . $e->getMessage(), 400);
        }
    }
}

