'use strict';

var jobBuilderController = angular.module('jobBuilderController', ['ui.bootstrap']);

jobBuilderController.controller('jobBuilderController', ['$scope', '$http', '$modal', '$rootScope', '$location', '$timeout', 'jobBuilderService',
    function ($scope, $http, $modal, $rootScope, $location, $timeout, jobBuilderService) {

        $scope.concatenating = false;
        $scope.concat = null;
        $scope.template = {};
        $scope.job = jobBuilderService.getActiveJob();
        $scope.request = {};

        $rootScope.$on('job:updated', function() {
            $scope.job = jobBuilderService.getActiveJob();
            $scope.updateApiJob();
        });

        $scope.updateApiJob = function () {
            $scope.request = jobBuilderService.updateApiJob($scope.job);
            $('.prettyprint').html(JSON.stringify($scope.request, null, 4)).removeClass('prettyprinted');
            prettyPrint();
        };

        $scope.toggleConcat = function ($index) {
            $scope.concatenating = !$scope.concatenating;
            $scope.concat = $index;
        };

        $scope.getRemotes = function () {
            $http.get(Routing.generate('isset_bv_hatchery_application_job_builder_remotes'))
                .then(function (result) {
                    $scope.remotes = result.data;
                });
        };
        $scope.getPresets = function () {
            $http.get(Routing.generate('isset_bv_hatchery_application_job_builder_presets', {actionType: 'video-transcode'}))
                .then(function (result) {
                    $scope.presets = result.data;
                });
        };
        $scope.getTemplates = function () {
            $http.get(Routing.generate('isset_bv_hatchery_application_job_builder_templates'))
                .then(function (result) {
                    $scope.templates = result.data;
                });
        };

        $scope.defaultJob = function () {
            $scope.job = {};
            $scope.job.inputs = [];

            var input = {};
            input.id = generateUuid();
            input.outputs = [];


            if ($location.search().filename && $location.search().location) {

                input.selected_remote = {"id": "upload", "name": "Your uploads", "type": "upload"};
                input.static = true;

                var remote = {};
                remote.files = [];
                remote.folders = [];
                remote.directory = "";
                remote.breadcrumb = [];
                remote.files = [];

                var file = {};
                file.location = $location.search().location;
                file.name = $location.search().filename;

                remote.files.push(file);

                input.file = file;
                input.remote = remote;
            }

            var output = {};
            output.id = generateUuid();
            input.outputs.push(output);
            $scope.job.inputs.push(input);
            $scope.updateApiJob();
        };

        $scope.closeTemplate = function() {
            $scope.template = {};
            //$scope.job = {};
            $scope.defaultJob();
        }

        $scope.getTemplate = function () {
            $http.get(Routing.generate('isset_bv_hatchery_application_job_builder_templates_data', {id: $scope.template.id})).success(function (data) {
                $scope.job = {};
                var job = data;
                $timeout(function() {
                    $scope.job = job;
                    $scope.updateApiJob();
                }, 1);
            });
        };
        $scope.getTemplates();
        $scope.getRemotes();
        $scope.getPresets();

        $scope.submit = function () {
            $http.post(Routing.generate('isset_bv_hatchery_application_job_builder_submit'), {job: JSON.stringify($scope.request)})
                .success(function (data) {
                    jobBuilderService.setActiveJob({});
                    $rootScope.$broadcast('jobs:update');
                    
                    window.location = data;
                }).error(function (data) {
                    $scope.submit_error = data;
                });
        };

        $scope.createTemplate = function ($template) {
            var postData = $http.post(Routing.generate('isset_bv_hatchery_application_job_builder_templates_create'), {
                job: JSON.stringify($scope.job),
                template: $template.name
            });

            postData.then(function (result) {
                $scope.getTemplates();
                $scope.modalInstance.dismiss('cancel');
            }, function (result) {
                $scope.template.error = result.data;
            });
        };
        $scope.editTemplate = function ($template) {
            var postData = $http.post(Routing.generate('isset_bv_hatchery_application_job_builder_templates_edit', {id: $template.id}), {
                job: JSON.stringify($scope.job),
                template: $scope.template.name
            });

            postData.then(function (result) {
                $scope.getTemplates();
                $scope.modalInstance.dismiss('cancel');
            }, function (result) {
                $scope.template.error = result.data;
            });
        };
        $scope.deleteTemplate = function ($template) {
            var postData = $http.post(Routing.generate('isset_bv_hatchery_application_job_builder_templates_delete', {id: $template.id}));

            postData.then(function (result) {
                $scope.getTemplates();
                $scope.modalInstance.dismiss('cancel');
                $scope.template = {};
            }, function (result) {
                $scope.template.error = result.data;
            });
        };


        $scope.browseRemote = function ($element, $index, $directory) {

            if ($index.type === 'archive') {
                $scope.browse('isset_bv_hatchery_application_job_builder_browse_archive', $element, $index, $directory);
            } else if ($index.type === 'upload') {
                $scope.browse('isset_bv_hatchery_application_job_builder_browse_uploads', $element, $index, $directory);
            } else {
                $scope.browse('isset_bv_hatchery_application_job_builder_browse_remote', $element, $index, $directory);
            }
        };

        $scope.browse = function ($endPoint, $element, $index, $directory) {
            $element.error = false;
            $element.loading = true;
            $element.selected_remote = $index;

            $http.get(Routing.generate($endPoint, {
                remoteIdentifier: $element.selected_remote.id,
                directory: $directory
            })).success(function (data) {
                $element.loading = false;
                $element.remote = data;
                $scope.updateApiJob();
            }).error(function (data) {
                $element.loading = false;
                $element.error = true;
                $element.remote = null;
            });
        };

        $scope.selectDownload = function ($element) {
            $element.selected_remote = {id: 'download', name: 'download', type: 'download'};
            $element.remote = {files: []};
            $scope.updateApiJob();
        };


        $scope.populateModal = function ($type, $element) {
            var modal = {};
            modal.type = $type;
            modal.element = $element;

            $scope.modal = modal;

            $scope.modalInstance = $modal.open({
                templateUrl: '/bundles/issetbvjobbuilder/partials/options.html',
                scope: $scope
            });
        };

        $scope.templateModal = function () {
            $scope.modalInstance = $modal.open({
                templateUrl: '/bundles/issetbvjobbuilder/partials/template.html',
                scope: $scope
            });
        };

        $scope.cancel = function () {
            $scope.modalInstance.dismiss('cancel');
        };

        $scope.addInput = function () {
            if (!$scope.job) {
                $scope.job = {}
            }

            if (!$scope.job.inputs) {
                $scope.job.inputs = [];
            }

            var $input = {};
            $input.id = generateUuid();

            $scope.job.inputs.push($input);
            $scope.updateApiJob();
        };

        $scope.addTranscode = function ($element) {
            if (!$element.outputs) {
                $element.outputs = [];
            }

            var $output = {};
            $output.id = generateUuid();

            if ($element.selected_remote) {
                $output.selected_remote = angular.copy($element.selected_remote);
                $output.remote = angular.copy($element.remote);
            }

            $element.outputs.push($output);
            $scope.updateApiJob();
        };

        $scope.addTask = function ($element, $type, $inherit) {

            if (!$element.tasks) {
                $element.tasks = [];
            }

            var object = {};
            object.id = generateUuid();
            object._type = $type;

            if ($inherit.selected_remote) {
                object.selected_remote = angular.copy($inherit.selected_remote);
                object.remote = angular.copy($inherit.remote);
            }
            $element.tasks.push(object);
            $scope.updateApiJob();
        };

        $scope.addConcatTask = function () {

            if (!$scope.job.concatenates) {
                $scope.job.concatenates = [];
            }

            var object = {};
            object.id = generateUuid();
            object.type = 'concatenate';
            object.sources = [];

            $scope.job.concatenates.push(object);
            $scope.updateApiJob();
        };
        $scope.addConcatSource = function ($element) {
            $scope.concat.sources.push($element.id);
            $scope.updateApiJob();
        };
        $scope.removeInput = function ($input) {
            $scope.job.inputs.splice($input, 1);
            $scope.updateApiJob();
        };
        $scope.removeConcat = function ($concat) {
            $scope.job.concatenates.splice($concat, 1);
            $scope.updateApiJob();
            $scope.concatenating = false;
        };
        $scope.removeTranscode = function ($output, $input) {
            $scope.job.inputs[$input].outputs.splice($output, 1);
            $scope.updateApiJob();
        };
        $scope.removeTask = function ($task, $output, $input) {
            $scope.job.inputs[$input].outputs[$output].tasks.splice($task, 1);
            $scope.updateApiJob();
        };

        $scope.buildUrl = function ($element) {
            return jobBuilderService.buildUrl($element);
        };

        $scope.buildBaseUrl = function ($element) {
            return jobBuilderService.buildBaseUrl($element);
        };

        $scope.buildOptions = function (output, $element, options) {
            return jobBuilderService.buildOptions(output, $element, options);
        };

        $scope.buildTransferJob = function () {
            $scope.job_type = 'transfer';

            angular.forEach($scope.job.inputs, function (input) {
                angular.forEach(input.outputs, function (output) {
                    output.selected_remote = null;
                    output.remote = null;
                });
            });

            $scope.updateApiJob();
        };

        $scope.buildDownloadJob = function () {
            $scope.job_type = 'download';

            angular.forEach($scope.job.inputs, function (input) {
                angular.forEach(input.outputs, function (output) {

                    output.selected_remote = {id: 'download', name: 'download', type: 'download'};
                    output.remote = {files: []};
                });
            });

            $scope.updateApiJob();
        };

        $scope.buildTranscodeJob = function () {
            $scope.job_type = 'transcode';

            angular.forEach($scope.job.inputs, function (input) {
                angular.forEach(input.outputs, function (output) {
                    output.selected_remote = null;
                    output.remote = null;
                });
            });

            $scope.updateApiJob();
        };

    }
]).service('jobBuilderService', ['$http',
    function ($http) {
        var activeJob = {};
        var self = this;

        this.setActiveJob = function(job) {
            activeJob = job;
        }

        this.getActiveJob = function() {
            if(false == angular.isArray(activeJob.inputs)) {
                activeJob.inputs = [];
            }
            return activeJob;
        }

        this.updateApiJob = function (job) {
            var request = {};

            request.inputs = [];
            request.outputs = [];

            var playlist = {};
            playlist.type = 'playlist';
            playlist.reference = generateUuid();
            playlist.filename = 'playlist.m3u8';
            playlist.streams = [];

            angular.forEach(job.inputs, function (inputItem) {
                var input = {};
                input.reference = inputItem.id;
                input.url = self.buildUrl(inputItem, true);
                request.inputs.push(input);

                angular.forEach(inputItem.outputs, function (outputItem) {
                    var output = {};
                    output.reference = outputItem.id;
                    output.source = input.reference;
                    output.filename = outputItem.filename;

                    if (outputItem.selected_remote && outputItem.selected_remote.type === 'download') {
                        output.download = true;
                    } else {
                        output.base_url = self.buildBaseUrl(outputItem);
                    }

                    request.outputs.push(output);
                    self.buildOptions(output, outputItem, ['preset', 'seek_offset', 'output_length', 'width', 'height', 'deinterlace', 'type']);


                    if (outputItem.type === 'segmented') {
                        playlist.base_url = output.base_url;
                        playlist.streams.push(output.reference);
                    }

                    angular.forEach(outputItem.tasks, function (taskItem) {

                        if (taskItem === 'caption') {
                            output.caption_url = self.buildUrl(taskItem);
                        } else if (taskItem._type === 'transfer') {
                            var transfer = {};
                            transfer.type = "transfer-only";
                            transfer.source = output.reference;
                            transfer.base_url = self.buildBaseUrl(taskItem);
                            transfer.filename = taskItem.filename;
                            request.outputs.push(transfer);
                        } else if (taskItem._type === 'watermark') {
                            if (!output.watermarks) {
                                output.watermarks = [];
                            }

                            var watermark = {};
                            watermark.url = self.buildUrl(taskItem);
                            self.buildOptions(watermark, taskItem, ['width', 'height', 'x', 'y']);

                            output.watermarks.push(watermark);
                        } else if (taskItem._type === 'stills') {
                            if (!output.stills) {
                                output.stills = [];
                            }

                            var stills = {};
                            stills.base_url = self.buildBaseUrl(taskItem);
                            stills.filename = taskItem.filename;
                            self.buildOptions(stills, taskItem, ['width', 'height', 'amount', 'format', 'timestamp']);

                            output.stills.push(stills);
                        }
                    });
                });
            });

            angular.forEach(job.concatenates, function (concatenateItem) {
                var output = {};
                output.type = 'concatenate';
                output.source = concatenateItem.sources;
                output.base_url = self.buildBaseUrl(concatenateItem);
                output.filename = concatenateItem.filename;
                request.outputs.push(output);
            });

            if (playlist.streams.length > 0) {
                request.outputs.push(playlist);
            }

            return request;

        };


        this.buildUrl = function (element) {
            if (element.remote && element.selected_remote.id === 'upload') {
                if (element.file && element.file.location) {
                    return element.file.location;
                } else if (element.file && !element.file.location) {
                    return '';
                }
            }

            if (element.remote && element.selected_remote.id === 'archive') {
                if (element.file) {
                    return 'va://my.videoarchive.io/' + element.file.location;
                } else if (element.remote.directory) {
                    return 'va://my.videoarchive.io/' + element.remote.directory;
                } else {
                    return 'va://my.videoarchive.io/'
                }
            }

            if (element.remote && element.file) {
                return 'remote://' + element.selected_remote.id + '/' + element.file.location;
            } else if (element.remote) {
                return 'remote://' + element.selected_remote.id + '/';
            } else {
                return '';
            }
        };

        this.buildBaseUrl = function (element) {

            if (element.remote && element.selected_remote.id === 'archive') {
                if (element.remote.directory) {
                    return 'va://my.videoarchive.io/' + element.remote.directory;
                } else {
                    return 'va://my.videoarchive.io/'
                }
            }

            if (element.remote && element.remote.directory) {
                return 'remote://' + element.selected_remote.id + '/' + element.remote.directory;
            } else if (element.remote) {
                return 'remote://' + element.selected_remote.id + '/';
            } else {
                return '';
            }
        };

        this.buildOptions = function (output, element, options) {
            angular.forEach(options, function (option) {
                if (element.hasOwnProperty(option) && element[option]) {
                    output[option] = element[option];
                }
            });
        };
    }
]).
    filter('getIcon', function () {
        return function (type) {
            switch (type.toLowerCase()) {
                case 'ftp':
                    return 'fa-share-alt';
                case 'dropbox':
                    return 'fa-dropbox';
                case 'googledrive':
                    return 'fa-google';
                case 'archive':
                    return 'fa-cloud';
                case 'amazon':
                    return 'fa-cube';
                case 'youtube':
                    return 'fa-youtube';
                case 'input':
                    return 'fa-file-video-o';
                case 'transcode':
                    return 'fa-tasks';
                case 'segmented':
                    return 'fa-tasks';
                case 'transfer':
                    return 'fa-share-alt';
                case 'stills':
                    return 'fa-picture-o';
                case 'watermark':
                    return 'fa-copyright';
                case 'caption':
                    return 'fa-comments-o';
                case 'concatenate':
                    return 'fa-paperclip';
                case 'upload':
                    return 'fa-upload';
            }

        }
    }).filter('positionInArray', function () {
        return function (array, value) {
            return array.indexOf(value) !== -1 ? array.indexOf(value) + 1 : null;
        };
    });

function generateUuid() {
    function s4() {
        return Math.floor((1 + Math.random()) * 0x10000)
            .toString(16)
            .substring(1);
    }

    return s4() + s4() + '-' + s4() + '-' + s4() + '-' +
        s4() + '-' + s4() + s4() + s4();
}

function secondsToTimestamp(secondsRaw) {
    var sec_num = parseInt(secondsRaw, 10);

    var hours = Math.floor(sec_num / 3600);
    var minutes = Math.floor((sec_num - (hours * 3600)) / 60);
    var seconds = sec_num - (hours * 3600) - (minutes * 60);

    if (hours < 10) {
        hours = "0" + hours;
    }
    if (minutes < 10) {
        minutes = "0" + minutes;
    }
    if (seconds < 10) {
        seconds = "0" + seconds;
    }

    return hours + ':' + minutes + ':' + seconds;
}