<?php

namespace IssetBV\JobBuilderBundle\Entity;

use DateTime;
use Doctrine\ORM\Mapping as ORM;
use Exception;
use IssetBV\MijnIssetAuthBundle\Entity\OauthUser;

/**
 * Class Notice
 *
 * @package IssetBV\JobBuilderBundle\Entity
 * @author Bart Malestein <bart@isset.nl>
 * @ORM\Entity(repositoryClass="IssetBV\JobBuilderBundle\Repository\JobTemplateRepository")
 * @ORM\Table(name="job_template")
 */
class JobTemplate
{

    /**
     * @var integer
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;

    /**
     * @var string
     * @ORM\Column(name="content", type="text", nullable=false)
     */
    protected $data;

    /**
     * @var string
     * @ORM\Column(name="name", type="string", nullable=false)
     */
    protected $name;

    /**
     * @var DateTime
     * @ORM\Column(name="date_deleted", type="datetime", nullable=true)
     */
    protected $dateDeleted;

    /**
     * @var DateTime
     * @ORM\Column(name="date_created", type="datetime", nullable=false)
     */
    protected $dateCreated;

    /**
     * @var DateTime
     * @ORM\Column(name="date_updated", type="datetime", nullable=false)
     */
    protected $dateUpdated;

    /**
     * @var string
     * @ORM\Column(name="division_uuid", type="string", nullable=true)
     */
    protected $division;

    /**
     * @param $division
     * @param $name
     * @param $data
     */
    public function __construct($division, $name, $data)
    {
        $this->division = $division;
        $this->name = $name;
        $this->data = $data;
        $this->dateCreated = new DateTime();
        $this->dateUpdated = new DateTime();
    }

    /**
     * @return string
     */
    public function getData()
    {
        return $this->data;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param $divisionUuid
     * @param $name
     * @param $data
     * @throws Exception
     */
    public function update($divisionUuid, $name, $data)
    {
        if ($this->division === $divisionUuid) {
            $this->name = $name;
            $this->data = $data;
            $this->dateUpdated = new DateTime();
        } else {
            throw new Exception('Unauthorized to update template');
        }


    }

    /**
     * @param $divisionUuid
     * @throws Exception
     */
    public function delete($divisionUuid)
    {
        if ($this->division === $divisionUuid) {
            $this->dateDeleted = new DateTime();
        } else {
            throw new Exception('Unauthorized to delete template');
        }
    }

}