<?php

namespace IssetBV\JobBuilderBundle\Service\Presenter;

/**
 * Class UploadResponsePresenter
 * @package IssetBV\JobBuilderBundle\Service\Presenter
 * @author Bart Malestein <bart@isset.nl>
 */
class UploadResponsePresenter
{

    /**
     * @param array $uploads
     * @return array
     */
    public function presentFiles(array $uploads)
    {

        $files = [];
        foreach ($uploads as $upload) {
            $files[] = [
                'name' => $upload['filename'],
                'location' => $upload['url']
            ];
        }

        return [
            'files' => $files,
            'folders' => [],
            'directory' => '',
            'breadcrumb' => ''
        ];
    }
}