<?php

namespace IssetBV\JobBuilderBundle\Controller;

use Exception;
use IssetBV\JobBuilderBundle\Interfaces\ArchiveServiceInterface;
use IssetBV\JobBuilderBundle\Interfaces\FilesServiceInterface;
use IssetBV\JobBuilderBundle\Interfaces\PresetServiceInterface;
use IssetBV\JobBuilderBundle\Interfaces\RemoteServiceInterface;
use IssetBV\JobBuilderBundle\Service\Presenter\ArchiveResponsePresenter;
use IssetBV\JobBuilderBundle\Service\Presenter\FilesResponsePresenter;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;

/**
 * Class ApiController
 * @package IssetBV\JobBuilderBundle\Controller
 * @author Bart Malestein <bart@isset.nl>
 */
class ApiController extends Controller
{

    /**
     * @return JsonResponse
     */
    public function remotesAction()
    {

        if (false === $this->container->has($this->container->getParameter('job.builder.remote.service.name'))) {

            return new JsonResponse('No service configured for fetching remotes', 404);
        }
        if (false === $this->container->get($this->container->getParameter('job.builder.remote.service.name')) instanceof RemoteServiceInterface) {

            return new JsonResponse('Service should implement RemoteServiceInterface', 404);
        }


        /** @var RemoteServiceInterface $remoteService */
        $remoteService = $this->container->get($this->container->getParameter('job.builder.remote.service.name'));

        $data = $remoteService->listRemotes();

        if (!is_array($data)) {

            return new JsonResponse('Invalid response, expecting array', 400);
        }

        return new JsonResponse($data);
    }

    /**
     * @param Request $request
     * @return JsonResponse
     */
    public function presetsAction(Request $request)
    {
        if (false === $this->container->has($this->container->getParameter('job.builder.preset.service.name'))) {

            return new JsonResponse('No service configured for retrieving presets', 404);
        }
        if (false === $this->container->get($this->container->getParameter('job.builder.preset.service.name')) instanceof PresetServiceInterface) {

            return new JsonResponse('Service should implement PresetServiceInterface', 404);
        }

        /** @var PresetServiceInterface $presetService */
        $presetService = $this->container->get($this->container->getParameter('job.builder.preset.service.name'));

        $data = $presetService->listPresets($request->get('actionType'));

        return new JsonResponse($data);
    }

    /**
     * @param Request $request
     * @param $remoteIdentifier
     * @return JsonResponse
     */
    public function browseRemoteAction(Request $request, $remoteIdentifier)
    {
        $directory = rtrim(ltrim(urldecode($request->get('directory')), "/"), "/");
        $directory = (strlen($directory) > 0 ? $directory . "/" : $directory);

        if (false === $this->container->has($this->container->getParameter('job.builder.files.service.name'))) {

            return new JsonResponse('No service configured for file browsing', 404);
        }
        if (false === $this->container->get($this->container->getParameter('job.builder.files.service.name')) instanceof FilesServiceInterface) {

            return new JsonResponse('Service should implement FilesServiceInterface', 404);
        }


        /** @var FilesServiceInterface $fileService */
        $fileService = $this->container->get($this->container->getParameter('job.builder.files.service.name'));

        $data = $fileService->listFiles($remoteIdentifier, $directory);

        if(!is_array($data)){

            return new JsonResponse('Invalid response, expecting array', 400);
        }

        /** @var FilesResponsePresenter $presenter */
        $presenter = $this->get('job.builder.files.response.presenter');

        return new JsonResponse($presenter->presentFiles($data, $directory));
    }


    /**
     * @param Request $request
     * @return JsonResponse
     */
    public function browseArchiveAction(Request $request)
    {
        $directory = rtrim(ltrim(urldecode($request->get('directory')), "/"), "/");
        $directory = (strlen($directory) > 0 ? $directory . "/" : $directory);

        if (false === $this->container->has($this->container->getParameter('job.builder.archive.service.name'))) {

            return new JsonResponse('No service configured for archive browsing', 404);
        }
        if (false === $this->container->get($this->container->getParameter('job.builder.archive.service.name')) instanceof ArchiveServiceInterface) {

            return new JsonResponse('Service should implement ArchiveServiceInterface', 404);
        }


        /** @var ArchiveServiceInterface $archiveService */
        $archiveService = $this->container->get($this->container->getParameter('job.builder.archive.service.name'));

        $data = $archiveService->listFiles($directory);

        if(!is_array($data)){

            return new JsonResponse('Invalid response, expecting array', 400);
        }

        /** @var ArchiveResponsePresenter $presenter */
        $presenter = $this->get('job.builder.archive.response.presenter');

        return new JsonResponse($presenter->presentFiles($data, $directory));
    }


}