<?php

declare(strict_types=1);

namespace IssetBV\Http\Client;

class Options implements OptionsInterface
{
    private $options = [];

    /**
     * @param string $name
     * @param $value
     */
    public function setOption(string $name, $value)
    {
        $this->options[$name] = $value;
    }

    /**
     * @param string $name
     *
     * @return bool
     */
    public function hasOption(string $name): bool
    {
        return array_key_exists($name, $this->options);
    }

    /**
     * @param string $name
     *
     * @return mixed
     */
    public function getOption(string $name)
    {
        if ($this->hasOption($name)) {
            return $this->options[$name];
        }
    }

    /**
     * @return array
     */
    public function getOptions(): array
    {
        return $this->options;
    }
}
