<?php

declare(strict_types=1);

namespace IssetBV\Http\Client\Exception;

use Exception;
use Psr\Http\Message\ResponseInterface;

class ResponseException extends Exception implements ResponseExceptionInterface
{
    /**
     * @var ResponseInterface
     */
    private $response;

    public function setResponse(ResponseInterface $response)
    {
        $this->response = $response;
    }

    public function getResponse(): ResponseInterface
    {
        if (null === $this->response) {
            throw new \LogicException('no response found in exception');
        }

        return $this->response;
    }

    public static function create(string $message, ResponseInterface $response)
    {
        $instance = new static($message);
        $instance->setResponse($response);
        return $instance;
    }
}
