<?php

declare(strict_types=1);

namespace IssetBV\Http\Client;

interface OptionsInterface
{
    const CONNECT_TIMEOUT = 'connect_timeout';
    const READ_TIMEOUT = 'read_timeout';

    /**
     * @param string $name
     * @param $value
     */
    public function setOption(string $name, $value);

    /**
     * @param string $name
     *
     * @return bool
     */
    public function hasOption(string $name): bool;

    /**
     * @param string $name
     *
     * @return mixed
     */
    public function getOption(string $name);

    /**
     * @return array
     */
    public function getOptions(): array;
}
