<?php

declare(strict_types=1);

namespace IssetBV\Http\Client;

use IssetBV\Http\Client\Exception\ConnectExceptionInterface;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\StreamInterface;

interface ClientInterface
{
    /**
     * @param RequestInterface $request
     * @param OptionsInterface|null $options
     *
     * @throws ConnectExceptionInterface
     *
     * @return ResponseInterface
     */
    public function call(RequestInterface $request, OptionsInterface $options = null): ResponseInterface;

    /**
     * @param string $method
     * @param string $uri
     * @param array $headers
     * @param string|null|resource|StreamInterface $body
     * @param string $version
     *
     * @return RequestInterface
     */
    public function create(
        string $method,
        string $uri,
        array $headers = [],
        $body = null,
        string $version = '1.1'
    ): RequestInterface;

    /**
     * @deprecated
     *
     * @return RequestGeneratorInterface
     */
    public function getRequestGenerator(): RequestGeneratorInterface;

    /**
     * @return StreamGeneratorInterface
     */
    public function getStreamGenerator(): StreamGeneratorInterface;
}
