<?php

declare(strict_types=1);

namespace IssetBV\Http\Client;

use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;

interface ClientInterface
{
    /**
     * @param RequestInterface $request
     * @param OptionsInterface|null $options
     *
     * @return ResponseInterface
     */
    public function call(RequestInterface $request, OptionsInterface $options = null): ResponseInterface;

    /**
     * @return RequestGeneratorInterface
     */
    public function getRequestGenerator(): RequestGeneratorInterface;

    /**
     * @return StreamGeneratorInterface
     */
    public function getStreamGenerator(): StreamGeneratorInterface;
}
