<?php

declare(strict_types=1);

namespace IssetBV\HttpCallbackQueuedBundle\Service\Queue;

use IssetBV\Queuing\Message\MessageInterface;
use IssetBV\Queuing\Message\Queuer\QueuerInterface;

class AMQPDelayedQueuer implements DelayedQueuerInterface
{
    /**
     * @var QueuerInterface
     */
    private $queuer;

    public function __construct(QueuerInterface $queuer)
    {
        $this->queuer = $queuer;
    }

    public function queue(MessageInterface $message, int $delayMS = null)
    {
        if (null === $delayMS) {
            $this->queuer->queue($message);
        } else {
            $this->queuer->queue($message, ['x-delay' => $delayMS]);
        }
    }
}
