<?php

declare(strict_types=1);

namespace IssetBV\HttpCallbackQueuedBundle\Service\Message;

use IssetBV\HttpCallback\HttpCallbackTryHandlerInterface;
use IssetBV\HttpCallback\Processor\ProcessorProviderInterface;
use IssetBV\Queuing\Message\Consumer\ConsumerInterface;
use IssetBV\Queuing\Message\Consumer\Response;
use IssetBV\Queuing\Message\Consumer\ResponseInterface;
use IssetBV\Queuing\Message\MessageInterface;
use RuntimeException;

class CallbackTryMessageConsumer implements ConsumerInterface
{
    /**
     * @var ProcessorProviderInterface
     */
    private $processorProvider;
    /**
     * @var HttpCallbackTryHandlerInterface
     */
    private $httpCallbackTryHandler;

    public function __construct(ProcessorProviderInterface $processorProvider, HttpCallbackTryHandlerInterface $httpCallbackTryHandler)
    {
        $this->processorProvider = $processorProvider;
        $this->httpCallbackTryHandler = $httpCallbackTryHandler;
    }

    /**
     * @param MessageInterface|CallbackTryMessage $message
     *
     * @return ResponseInterface
     */
    public function consume(MessageInterface $message): ResponseInterface
    {
        if (!($message instanceof CallbackTryMessage)) {
            throw new RuntimeException('CallbackTryMessageConsumer: expected <' . CallbackTryMessage::class . '> got <' . \get_class($message) . '>');
        }
        $callbackTry = $this->processorProvider->fetchByUUID($message->getUUID());
        if (null === $callbackTry) {
            return Response::reject();
        }
        $this->httpCallbackTryHandler->handle($callbackTry);

        return Response::accept();
    }

    public function consumes(MessageInterface $message): bool
    {
        return $message instanceof CallbackTryMessage;
    }
}
