<?php

declare(strict_types=1);

namespace IssetBV\HttpCallbackQueuedBundle\Service\Message;

use IssetBV\Queuing\Message\MessageInterface;
use JMS\Serializer\Annotation as JMS;

/**
 * @JMS\ExclusionPolicy("all")
 */
class CallbackTryMessage implements MessageInterface
{
    /**
     * @var string
     * @JMS\Expose
     * @JMS\Type("string")
     */
    private $uuid;

    /**
     * @return string
     */
    public function getUUID(): string
    {
        return $this->uuid;
    }

    /**
     * @param string $uuid
     */
    public function setUUID(string $uuid)
    {
        $this->uuid = $uuid;
    }

    public static function getType(): string
    {
        return 'http_callback_queued_message';
    }

    public static function getVersion(): string
    {
        return 'v1';
    }
}
