<?php

declare(strict_types=1);

namespace IssetBV\HttpCallbackQueuedBundle\Service;

use IssetBV\HttpCallback\HttpCallbackTryEventInterface;
use IssetBV\HttpCallback\HttpCallbackTryInterface;
use IssetBV\HttpCallback\Processor\ProcessorInterface;
use IssetBV\HttpCallbackQueuedBundle\Service\Message\CallbackTryMessage;
use IssetBV\HttpCallbackQueuedBundle\Service\Queue\DelayedQueuerInterface;
use IssetBV\Queuing\Message\MessageInterface;

class HttpCallbackTryEventListener
{
    /**
     * @var DelayedQueuerInterface
     */
    private $delayedQueuerNew;
    /**
     * @var DelayedQueuerInterface
     */
    private $delayedQueuerRetry;

    public function __construct(DelayedQueuerInterface $delayedQueuerNew, DelayedQueuerInterface $delayedQueuerRetry)
    {
        $this->delayedQueuerNew = $delayedQueuerNew;
        $this->delayedQueuerRetry = $delayedQueuerRetry;
    }

    public function handle(HttpCallbackTryEventInterface $httpCallbackTryEvent)
    {
        $httpCallbackTry = $httpCallbackTryEvent->getHttpCallbackTry();
        $this->getQueuer($httpCallbackTry)->queue($this->buildMessage($httpCallbackTry), $this->calculateDifference($httpCallbackTry));
    }

    private function calculateDifference(HttpCallbackTryInterface $httpCallbackTry)
    {
        $difference = $httpCallbackTry->getSendDate()->getTimestamp() - time();

        return $difference > 0 ? ($difference * 1000) : null;
    }

    private function buildMessage(HttpCallbackTryInterface $httpCallbackTry): MessageInterface
    {
        $message = new CallbackTryMessage();
        $message->setUUID($httpCallbackTry->getUUID());

        return $message;
    }

    private function getQueuer(HttpCallbackTryInterface $httpCallbackTry): DelayedQueuerInterface
    {
        if (ProcessorInterface::TYPE_NEW === $httpCallbackTry->getType()) {
            return $this->delayedQueuerNew;
        }

        return $this->delayedQueuerRetry;
    }
}
