<?php

declare(strict_types=1);

namespace IssetBV\HttpCallbackDoctrineBundle\Repository;

use DateTime;
use Doctrine\ORM\EntityRepository;
use IssetBV\HttpCallbackDoctrineBundle\Entity\HttpCallback;

class HttpCallbackRepository extends EntityRepository
{
    /**
     * @param DateTime $checkDate
     *
     * @return HttpCallback[]
     */
    public function fetchToBeCleanedFrom(DateTime $checkDate): array
    {
        $qb = $this->createQueryBuilder('hc');
        $qb->where('(hc.failedDate < :checkDate OR hc.sentDate < :checkDate)');
        $qb->andWhere('hc.cleanedDate IS NULL');
        $qb->setParameters(['checkDate' => $checkDate]);

        return $qb->getQuery()->getResult();
    }
}
