<?php

declare(strict_types=1);

namespace IssetBV\HttpCallbackDoctrineBundle\Repository;

use DateTime;
use Doctrine\ORM\EntityRepository;
use IssetBV\HttpCallback\HttpCallbackTryInterface;
use IssetBV\HttpCallback\Processor\ProcessorInterface;
use IssetBV\HttpCallback\Processor\ProcessorProviderInterface;
use IssetBV\HttpCallbackDoctrineBundle\Entity\HttpCallbackTry;

class HttpCallbackTryRepository extends EntityRepository implements ProcessorProviderInterface
{
    /**
     * @param string $type
     * @param int $amount
     * @param DateTime $dateUsed
     *
     * @return HttpCallbackTryInterface[]
     */
    public function fetchNextAmountAndType(string $type, int $amount, DateTime $dateUsed): array
    {
        $qb = $this->createQueryBuilder('try');

        $qb->select('try, callback');
        $qb->join('try.httpCallback', 'callback');
        $qb->where('try.status = :status');
        $qb->andWhere('try.type = :type');
        $qb->andWhere('try.sendDate <= :sendDate');
        $qb->orderBy('try.created', 'ASC');
        $qb->setMaxResults($amount);
        $qb->setParameters([
            'status' => ProcessorInterface::STATUS_PENDING,
            'type' => $type,
            'sendDate' => $dateUsed,
        ]);

        return $qb->getQuery()->getResult();
    }

    /**
     * @param string $uuid
     *
     * @return HttpCallbackTryInterface|null
     */
    public function fetchByUUID(string $uuid)
    {
        $qb = $this->createQueryBuilder('try');
        $qb->select('try, callback');
        $qb->join('try.httpCallback', 'callback');
        $qb->where('try.uuid = :uuid');
        $qb->setParameters(['uuid' => $uuid]);
        $result = $qb->getQuery()->getOneOrNullResult();

        return $result instanceof HttpCallbackTry ? $result : null;
    }
}
