<?php

declare(strict_types=1);

namespace IssetBV\HttpCallbackDoctrineBundle\Entity;

use DateTime;
use Doctrine\ORM\Mapping as ORM;
use IssetBV\HttpCallback\HttpCallbackDataInterface;
use IssetBV\HttpCallback\HttpCallbackTryInterface;
use Ramsey\Uuid\Uuid;

/**
 * @ORM\Table(name="issetbv_http_callback_tries", indexes={@ORM\Index(columns={"type", "status", "date_send"})})
 * @ORM\Entity(repositoryClass="IssetBV\HttpCallbackDoctrineBundle\Repository\HttpCallbackTryRepository")
 */
class HttpCallbackTry implements HttpCallbackTryInterface
{
    /**
     * @var int|null
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;
    /**
     * @var string
     *
     * @ORM\Column(type="string", nullable=false, unique=true)
     */
    private $uuid;
    /**
     * @ORM\ManyToOne(targetEntity="HttpCallback", inversedBy="tries")
     * @ORM\JoinColumn(onDelete="CASCADE")
     */
    private $httpCallback;
    /**
     * @var string
     * @ORM\Column(type="string", nullable=true)
     */
    private $type;
    /**
     * @var string
     *
     * @ORM\Column(type="string", nullable=true)
     */
    private $status;
    /**
     * @var DateTime
     *
     * @ORM\Column(name="date_send", type="datetime", nullable=false)
     */
    private $sendDate;
    /**
     * @var int|null
     *
     * @ORM\Column(type="integer", nullable=true)
     */
    private $statusCode;
    /**
     * @var string|null
     *
     * @ORM\Column(type="text", nullable=true)
     */
    private $response;
    /**
     * @var DateTime
     *
     * @ORM\Column(name="date_created", type="datetime", nullable=false)
     */
    private $created;
    /**
     * @var DateTime
     *
     * @ORM\Column(name="date_updated", type="datetime", nullable=false)
     */
    private $updated;

    public function __construct(string $type, string $status, HttpCallback $callback, DateTime $sendDate)
    {
        $this->uuid = Uuid::uuid4()->toString();
        $this->httpCallback = $callback;
        $this->sendDate = $sendDate;
        $this->created = new DateTime();
        $this->updated = new DateTime();
        $this->type = $type;
        $this->status = $status;
        $callback->addTry($this);
    }

    /**
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return $this->type;
    }

    /**
     * @param string $type
     */
    public function setType(string $type)
    {
        $this->type = $type;
    }

    /**
     * @return string
     */
    public function getStatus(): string
    {
        return $this->status;
    }

    /**
     * @param string $status
     */
    public function setStatus(string $status)
    {
        $this->status = $status;
        $this->updated = new DateTime();
    }

    /**
     * @return int|null
     */
    public function getStatusCode()
    {
        return $this->statusCode;
    }

    /**
     * @param int|null $statusCode
     */
    public function setStatusCode(int $statusCode = null)
    {
        $this->statusCode = $statusCode;
    }

    /**
     * @return null|string
     */
    public function getResponse()
    {
        return $this->response;
    }

    /**
     * @param null|string $response
     */
    public function setResponse(string $response = null)
    {
        $this->response = $response;
    }

    public function getHttpCallback(): HttpCallback
    {
        return $this->httpCallback;
    }

    /**
     * @return DateTime
     */
    public function getSendDate(): DateTime
    {
        return $this->sendDate;
    }

    /**
     * @return DateTime
     */
    public function getCreated(): DateTime
    {
        return $this->created;
    }

    /**
     * @return DateTime
     */
    public function getUpdated(): DateTime
    {
        return $this->updated;
    }

    public function getUUID(): string
    {
        return $this->uuid;
    }

    public function getHttpCallbackDataInterface(): HttpCallbackDataInterface
    {
        return $this->getHttpCallback();
    }
}
