<?php

declare(strict_types=1);

namespace IssetBV\HttpCallbackDoctrineBundle\Command;

use DateTime;
use IssetBV\HttpCallback\Processor\ProcessorInterface;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

class ProcessCommand extends Command
{
    /**
     * @var ProcessorInterface
     */
    private $processor;

    public function __construct(string $name = null, ProcessorInterface $processor)
    {
        parent::__construct($name);

        $this->processor = $processor;
    }

    protected function configure()
    {
        $this->setName('issetbv:http_callback:process');
        $this->addArgument('type', InputArgument::REQUIRED);
        $this->addOption('amount', null, InputOption::VALUE_OPTIONAL, 'Amount of callback to do', 20);
        $this->addOption('date_used', null, InputOption::VALUE_OPTIONAL, 'Time to use as check');
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $type = $input->getArgument('type');
        $amount = (int) $input->getOption('amount');
        $dateUsed = new DateTime($input->getOption('date_used') ?? 'now');
        $output->writeln('' . $this->processor->process($type, $amount, $dateUsed));
    }
}
