<?php

declare(strict_types=1);

namespace IssetBV\HttpCallbackDoctrineBundle\Command;

use DateTime;
use IssetBV\HttpCallbackDoctrineBundle\Repository\HttpCallbackRepository;
use IssetBV\HttpCallbackDoctrineBundle\Service\HttpCallbackCleaner;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

class CleanCommand extends Command
{
    /**
     * @var HttpCallbackRepository
     */
    private $httpCallbackRepository;
    /**
     * @var HttpCallbackCleaner
     */
    private $httpCallbackCleaner;

    public function __construct(
        string $name = null,
        HttpCallbackRepository $httpCallbackRepository,
        HttpCallbackCleaner $httpCallbackCleaner
    ) {
        parent::__construct($name);

        $this->httpCallbackRepository = $httpCallbackRepository;
        $this->httpCallbackCleaner = $httpCallbackCleaner;
    }

    protected function configure()
    {
        $this->setName('issetbv:http_callback:clean');
        $this->addOption('date_used', null, InputOption::VALUE_OPTIONAL, 'Time to use as check');
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $dateUsed = new DateTime($input->getOption('date_used') ?? '-2 weeks');
        if ($dateUsed > new DateTime()) {
            $output->writeln("Can't clean if date used is in the future");

            return;
        }
        $httpCallbacks = $this->httpCallbackRepository->fetchToBeCleanedFrom($dateUsed);
        $this->httpCallbackCleaner->cleanMulti($httpCallbacks);
    }
}
