<?php

declare(strict_types=1);

namespace IssetBV\HttpCallbackDoctrineBundle\Service;

use DateTime;
use Doctrine\Common\Persistence\ObjectManager;
use IssetBV\HttpCallback\HttpCallbackDataInterface;
use IssetBV\HttpCallback\HttpCallbackInterface;
use IssetBV\HttpCallback\Processor\ProcessorInterface;
use IssetBV\HttpCallback\Response\ResponseValidatorInterface;
use IssetBV\HttpCallbackDoctrineBundle\Entity\HttpCallback;
use IssetBV\HttpCallbackDoctrineBundle\Entity\HttpCallbackTry;
use RuntimeException;
use Symfony\Component\EventDispatcher\EventDispatcherInterface;

class HttpCallbackDoctrine implements HttpCallbackInterface
{
    /**
     * @var ObjectManager
     */
    private $objectManager;
    /**
     * @var EventDispatcherInterface
     */
    private $eventDispatcher;

    public function __construct(ObjectManager $objectManager, EventDispatcherInterface $eventDispatcher)
    {
        $this->objectManager = $objectManager;
        $this->eventDispatcher = $eventDispatcher;
    }

    public function create(
        string $method,
        string $url,
        array $headers = [],
        $body = null,
        ResponseValidatorInterface $responseValidator = null,
        string $groupIdentifier = null,
        string $version = '1.1'
    ): HttpCallbackDataInterface {
        $httpCallback = new HttpCallback();
        $httpCallback->setMethod($method);
        $httpCallback->setUrl($url);
        $httpCallback->setHeaders($headers);
        $httpCallback->setBody($body);
        $httpCallback->setResponseValidator($responseValidator);
        $httpCallback->setGroupIdentifier($groupIdentifier);
        $httpCallback->setVersion($version);

        return $httpCallback;
    }

    public function add(HttpCallbackDataInterface $httpCallbackData, DateTime $sendDate = null): string
    {
        if (!($httpCallbackData instanceof HttpCallback)) {
            throw new RuntimeException('HttpCallbackDoctrine: expected <' . HttpCallback::class . '> got <' . \get_class($httpCallbackData) . '>');
        }

        $try = new HttpCallbackTry(
            ProcessorInterface::TYPE_NEW,
            ProcessorInterface::STATUS_PENDING,
            $httpCallbackData,
            $sendDate ?? new DateTime()
        );

        $this->objectManager->persist($httpCallbackData);
        $this->objectManager->persist($try);
        $this->objectManager->flush();

        $httpCallbackAddedEvent = new HttpCallbackTryEvent($try);
        $this->eventDispatcher->dispatch(HttpCallbackTryEvent::EVENT_NAME, $httpCallbackAddedEvent);

        return $httpCallbackData->getUUID();
    }
}
