<?php

declare(strict_types=1);

namespace IssetBV\HttpCallbackDoctrineBundle\Service;

use Doctrine\Common\Persistence\ObjectManager;
use IssetBV\HttpCallbackDoctrineBundle\Entity\HttpCallback;

class HttpCallbackCleaner
{
    /**
     * @var ObjectManager
     */
    private $objectManager;

    public function __construct(ObjectManager $objectManager)
    {
        $this->objectManager = $objectManager;
    }

    public function clean(HttpCallback $httpCallback)
    {
        $this->cleanHttpCallback($httpCallback);
        $this->objectManager->flush();
    }

    public function cleanMulti(array $httpCallbacks)
    {
        foreach ($httpCallbacks as $httpCallback) {
            $this->cleanHttpCallback($httpCallback);
        }
        $this->objectManager->flush();
    }

    private function cleanHttpCallback(HttpCallback $httpCallback)
    {
        $httpCallback->setCleaned();
        $httpCallback->setBody(null);
        $httpCallback->setResponseValidator(null);
        foreach ($httpCallback->getTries() as $try) {
            $try->setResponse(null);
        }
    }
}
