<?php

declare(strict_types=1);

namespace IssetBV\HttpCallbackDoctrineBundle\DependencyInjection;

use IssetBV\HttpCallback\HttpCallbackInterface;
use IssetBV\HttpCallback\HttpCallbackTryHandlerInterface;
use IssetBV\HttpCallback\Processor\Processor;
use IssetBV\HttpCallback\Processor\ProcessorInterface;
use IssetBV\HttpCallback\Processor\ProcessorProviderInterface;
use IssetBV\HttpCallbackDoctrineBundle\Repository\HttpCallbackTryRepository;
use IssetBV\HttpCallbackDoctrineBundle\Service\HttpCallbackDoctrine;
use IssetBV\HttpCallbackDoctrineBundle\Service\HttpCallbackTryHandler;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Loader;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;

class IssetBVHttpCallbackDoctrineExtension extends Extension
{
    /**
     * {@inheritdoc}
     */
    public function load(array $configs, ContainerBuilder $container)
    {
        $configuration = new Configuration();
        $this->processConfiguration($configuration, $configs);

        $loader = new Loader\YamlFileLoader($container, new FileLocator(__DIR__ . '/../Resources/config'));
        $loader->load('services.yml');

        $processor = $container->register(Processor::class);
        $processor->setAutowired(true);

        $container->setAlias(HttpCallbackInterface::class, HttpCallbackDoctrine::class);
        $container->setAlias(HttpCallbackTryHandlerInterface::class, HttpCallbackTryHandler::class);
        $container->setAlias(ProcessorInterface::class, Processor::class);
        $container->setAlias(ProcessorProviderInterface::class, HttpCallbackTryRepository::class);
    }
}
