<?php

declare(strict_types=1);

namespace IssetBV\HttpCallback\Response;

use Psr\Http\Message\ResponseInterface as PsrResponseInterface;

class HttpCodeRangeValidator implements ResponseValidatorInterface, \Serializable
{
    /**
     * @var int
     */
    private $from;
    /**
     * @var int
     */
    private $to;

    public function __construct(int $from, int $to = null)
    {
        $this->from = $from;
        $this->to = $to ?? $from;
    }

    public function validateResponse(PsrResponseInterface $response): bool
    {
        return $this->validateStatusCode($response->getStatusCode());
    }

    public function validateStatusCode(int $statusCode): bool
    {
        return $statusCode >= $this->from && $statusCode <= $this->to;
    }

    public function serialize()
    {
        return serialize([
            $this->from,
            $this->to,
        ]);
    }

    public function unserialize($serialized)
    {
        list(
            $this->from,
            $this->to
            ) = unserialize($serialized);
    }
}
