<?php

declare(strict_types=1);

namespace IssetBV\HttpCallback\Processor;

use DateTime;
use IssetBV\HttpCallback\HttpCallbackTryHandlerInterface;

class Processor implements ProcessorInterface
{
    /**
     * @var ProcessorProviderInterface
     */
    private $processorProvider;

    /**
     * @var HttpCallbackTryHandlerInterface
     */
    private $callbackTryHandler;

    public function __construct(ProcessorProviderInterface $processorProvider, HttpCallbackTryHandlerInterface $callbackTryHandler)
    {
        $this->processorProvider = $processorProvider;
        $this->callbackTryHandler = $callbackTryHandler;
    }

    public function process(string $type, int $amount, DateTime $dateUsed): int
    {
        $callbackTries = $this->processorProvider->fetchNextAmountAndType($type, $amount, $dateUsed);

        foreach ($callbackTries as $callbackTry) {
            $this->callbackTryHandler->handle($callbackTry);
        }

        return \count($callbackTries);
    }
}
