<?php

declare(strict_types=1);

namespace IssetBV\HttpCallback\Processor;

use DateTime;
use IssetBV\HttpCallback\HttpCallbackTryInterface;

interface ProcessorProviderInterface
{
    /**
     * @param string $type
     * @param int $amount
     * @param DateTime $dateUsed
     *
     * @return HttpCallbackTryInterface[]
     */
    public function fetchNextAmountAndType(string $type, int $amount, DateTime $dateUsed): array;

    /**
     * @param string $uuid
     *
     * @return HttpCallbackTryInterface|null
     */
    public function fetchByUUID(string $uuid);
}
