<?php

declare(strict_types=1);

namespace IssetBV\HttpCallback;

use DateTime;
use IssetBV\HttpCallback\Response\ResponseValidatorInterface;

interface HttpCallbackInterface
{
    public function create(
        string $method,
        string $url,
        array $headers = [],
        $body = null,
        ResponseValidatorInterface $responseValidator = null,
        string $version = '1.1'
    ): HttpCallbackDataInterface;

    public function add(HttpCallbackDataInterface $httpCallbackData, DateTime $sendDate = null): string;
}
