<?php

declare(strict_types=1);

namespace IssetBV\HttpCallback;

use IssetBV\HttpCallback\Response\ResponseValidatorInterface;

interface HttpCallbackDataInterface
{
    public function getUUID(): string;

    public function getMethod(): string;

    public function getUrl(): string;

    public function getHeaders(): array;

    public function getBody();

    public function getVersion(): string;

    public function getGroupIdentifier();

    /**
     * @return ResponseValidatorInterface|null
     */
    public function getResponseValidator();
}
