<?php

declare(strict_types=1);

namespace IssetBV\FormBundle\Service\Error;

use JsonSerializable;

class FormDataError implements JsonSerializable
{
    /**
     * @var string
     */
    private $code;
    /**
     * @var mixed
     */
    private $invalidValue;
    /**
     * @var string
     */
    private $message;

    /**
     * FormDataError constructor.
     *
     * @param string $code
     * @param $invalidValue
     * @param string $message
     */
    public function __construct(string $code, $invalidValue, string $message)
    {
        $this->code = $code;
        $this->invalidValue = $invalidValue;
        $this->message = $message;
    }

    /**
     * @return string
     */
    public function getCode(): string
    {
        return $this->code;
    }

    public function getInvalidValue()
    {
        return $this->invalidValue;
    }

    public function getMessage(): string
    {
        return $this->message;
    }

    public function toArray(): array
    {
        return [
            'code' => $this->getCode(),
            'invalid_value' => $this->getInvalidValue(),
            'message' => $this->getMessage(),
        ];
    }

    public function jsonSerialize()
    {
        return $this->toArray();
    }
}
