<?php

declare(strict_types=1);

namespace IssetBV\FormBundle\Service\Error;

use Symfony\Component\Form\FormError;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\Validator\ConstraintViolation;

class FormConverter
{
    /**
     * @param FormInterface $form
     * @param FormError[] $errors
     *
     * @return FormData
     */
    public function convertForm(FormInterface $form, array $errors = []): FormData
    {
        $formData = new FormData($form->isValid(), (string) $form->getPropertyPath());
        foreach ($form->getErrors() as $error) {
            if ($error instanceof FormError) {
                $errors[] = $error;
            } else {
                $formData->addError($this->convertFormConstraint($error->getCause()));
            }
        }

        foreach ($errors as $key => $error) {
            if ($form === $error->getOrigin()) {
                $formData->setValid(false);
                $formData->addError($this->convertFormConstraint($error->getCause()));
                unset($errors[$key]);
            }
        }

        foreach ($form->all() as $field => $subForm) {
            $formDataAdd = $this->convertForm($subForm, $errors);
            $formData->addField($field, $formDataAdd);
            if (!$formDataAdd->isValid()) {
                $formData->setValid(false);
            }
        }

        return $formData;
    }

    /**
     * @param ConstraintViolation $constraintViolation
     *
     * @return FormDataError
     */
    public function convertFormConstraint(ConstraintViolation $constraintViolation): FormDataError
    {
        return new FormDataError(
            $constraintViolation->getCode(),
            $constraintViolation->getInvalidValue(),
            $constraintViolation->getMessage()
        );
    }
}
