<?php

declare(strict_types=1);

namespace IssetBV\FormBundle\Service\Error;

use Symfony\Component\Form\FormInterface;
use Symfony\Component\Validator\ConstraintViolation;

/**
 * Class FormErrorConverter.
 */
class FormConverter
{
    /**
     * @param FormInterface $form
     * @return FormData
     */
    public function convertForm(FormInterface $form): FormData
    {
        $formData = new FormData($form->isValid(), (string) $form->getPropertyPath());
        foreach ($form->getErrors() as $error) {
            $formData->addError($this->convertFormConstraint($error->getCause()));
        }

        foreach ($form->all() as $field => $subForm) {
            $formData->addField($field, $this->convertForm($subForm));
        }

        return $formData;
    }

    /**
     * @param ConstraintViolation $constraintViolation
     *
     * @return FormDataError
     */
    public function convertFormConstraint(ConstraintViolation $constraintViolation): FormDataError
    {
        return new FormDataError(
            $constraintViolation->getCode(),
            $constraintViolation->getInvalidValue(),
            $constraintViolation->getMessage()
        );
    }
}
