<?php

declare(strict_types=1);

namespace IssetBV\FormBundle\DependencyInjection;

use IssetBV\ErrorBundle\Service\Generator\Data\DataConverter;
use IssetBV\ErrorBundle\Service\Generator\Data\DataConverterContainer;
use IssetBV\FormBundle\Service\Error\FormConverter;
use IssetBV\FormBundle\Service\FormDataConverter;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;

/**
 * This is the class that loads and manages your bundle configuration.
 *
 * @see http://symfony.com/doc/current/cookbook/bundles/extension.html
 */
class IssetBVFormExtension extends Extension
{
    /**
     * {@inheritdoc}
     */
    public function load(array $configs, ContainerBuilder $container)
    {
        $configuration = new Configuration();
        $this->processConfiguration($configuration, $configs);

        $container->register(FormConverter::class, FormConverter::class);

        if (interface_exists(DataConverter::class)) {
            $definition = $container->register(FormDataConverter::class, FormDataConverter::class);
            $definition->setAutowired(true);
            $definition->addTag(DataConverterContainer::TAG);
        }

    }
}
