<?php

declare(strict_types=1);

namespace IssetBV\FormBundle\Service\Error;

use JsonSerializable;

class FormDataError implements JsonSerializable
{
    /**
     * @var string
     */
    private $code;
    /**
     * @var mixed
     */
    private $invalidValue;
    /**
     * @var string
     */
    private $message;

    /**
     * FormDataError constructor.
     *
     * @param string $code
     * @param $invalidValue
     * @param string $message
     */
    public function __construct(string $code, $invalidValue, string $message)
    {
        $this->code = $code;
        $this->invalidValue = $invalidValue;
        $this->message = $message;
    }

    /**
     * @return string
     */
    public function getCode(): string
    {
        return $this->code;
    }

    /**
     * @return mixed
     */
    public function getInvalidValue()
    {
        return $this->invalidValue;
    }

    /**
     * @return string
     */
    public function getMessage(): string
    {
        return $this->message;
    }

    /**
     * Specify data which should be serialized to JSON.
     *
     * @see http://php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed data which can be serialized by <b>json_encode</b>,
     * which is a value of any type other than a resource
     *
     * @since 5.4.0
     */
    public function jsonSerialize()
    {
        return [
            'code' => $this->getCode(),
            'invalid_value' => $this->getInvalidValue(),
            'message' => $this->getMessage(),
        ];
    }
}
