<?php
declare(strict_types = 1);

namespace IssetBV\FixtureBundle\Service;

use Doctrine\ORM\EntityManagerInterface;

/**
 * Class FixtureHandler
 * @package IssetBV\FixtureBundle\Service
 */
class FixtureHandler
{

    /**
     * @var FixtureContainer
     */
    private $fixtureContainer;
    /**
     * @var EntityManagerInterface
     */
    private $entityManager;

    /**
     * FixtureHandler constructor.
     * @param FixtureContainer $fixtureContainer
     * @param EntityManagerInterface $entityManager
     */
    public function __construct(FixtureContainer $fixtureContainer, EntityManagerInterface $entityManager)
    {
        $this->fixtureContainer = $fixtureContainer;
        $this->entityManager = $entityManager;
    }

    /**
     * @return void
     */
    public function run()
    {
        foreach ($this->fixtureContainer->getAll() as $fixture) {
            $fixture->handle($this->entityManager);
        }
        $this->entityManager->flush();
    }

    /**
     * @param $name
     * @return void
     */
    public function runByName($name)
    {
        $fixture = $this->fixtureContainer->getByName($name);
        $fixture->handle($this->entityManager);
        $this->entityManager->flush();
    }

}