<?php
declare(strict_types = 1);

namespace IssetBV\FixtureBundle\Service;

/**
 * Class FixtureContainer
 * @package IssetBV\FixtureBundle\Service
 */
class FixtureContainer
{

    /**
     * @var FixtureInterface[]
     */
    private $fixtures = [];

    /**
     * @return FixtureInterface[]
     */
    public function getAll(): array
    {
        return $this->fixtures;
    }

    /**
     * @param $name
     * @return FixtureInterface
     * @throws \LogicException
     */
    public function getByName($name): FixtureInterface
    {
        foreach ($this->fixtures as $fixture) {
            if ($fixture->getName() === $name) {
                return $fixture;
            }
        }
        throw new \LogicException('fixture not found');

    }

    /**
     * @param FixtureInterface $fixture
     * @throws \LogicException
     */
    public function add(FixtureInterface $fixture)
    {
        foreach ($this->fixtures as $fixtureTemp) {
            if ($fixtureTemp->getName() === $fixture->getName()) {
                throw new \LogicException('fixture all ready registered');
            }
        }

        $this->fixtures[] = $fixture;
        usort($this->fixtures, function (FixtureInterface $a, FixtureInterface $b) {
            if ($a->getWeight() === $b->getWeight()) {
                return 0;
            }
            return $a->getWeight() > $b->getWeight() ? 1 : -1;
        });
    }
}