<?php
declare(strict_types=1);

namespace IssetBV\FixtureBundle\DependencyInjection;

use Symfony\Component\Config\Exception\FileLocatorFileNotFoundException;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Loader\YamlFileLoader;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;

/**
 * This is the class that loads and manages your bundle configuration.
 *
 * @link http://symfony.com/doc/current/cookbook/bundles/extension.html
 */
class IssetBVFixtureExtension extends Extension
{

    /**
     * {@inheritdoc}
     */
    public function load(array $configs, ContainerBuilder $container)
    {
        $configuration = new Configuration();
        $this->processConfiguration($configuration, $configs);
        $loader = new YamlFileLoader($container, new FileLocator(__DIR__ . '/../Resources/config'));
        $loader->load('services.yml');

        $base = $container->getParameter('kernel.root_dir') . '/../src/';
        $paths = [
            $base . '*/Resources/config',
            $base . '*/*/Resources/config',
            $base . '*/*/*/Resources/config'
        ];
        $fixtureLoader = new YamlFileLoader($container, new FileLocator($paths));
        try {
            $fixtureLoader->load('fixtures.yml');
        } catch (FileLocatorFileNotFoundException $e) {
            // No fixtures file found
        }

    }
}
